The first term of the above addition is the improvement of normalized **association moving** from stage k to k − **1 of the hierarchy and the second term is the improvement moving from** stage k **+ 1 to** k.

The function Curv(k) captures the notion that a particular number of clusters, k**, identifies meaningful structural similarities embodied in the graph if it provides a normalized**
association which is significantly larger than the best partition with one additional cluster
(k **+ 1) and little can be gained by reducing the number of clusters to** k − 1.

In practice we do not have access to the optimal partitions, so we cannot evaluate the exact value of the curvature function. Instead, we approximate **the curvature by using the** normalized association values for the partitions returned by the agglomerative step of our algorithm.

Note that the model order selection step of the algorithm could be used as a model order selection step for any other algorithm that maximizes the normalized association and generates a clustering hierarchy. Furthermore, this step of the **algorithm can be considered** optional if there is a prior knowledge about the true number of clusters.

## 4.3. Refinement

Greedy algorithms can get trapped by local optima. This is also the case with the agglomerative step of our algorithm, especially when the clusters are not clearly separated. After selecting the number of clusters either using the model order selection rule described previously or prior knowledge, a refinement step is invoked in order to improve the initial clustering results. The nodes are moved across the clusters to further improve the value of normalized association. A similar approach is taken in [56], but groups of nodes are moved from a cluster to another instead of individual nodes. If we try all possible moves, we end up performing an exhaustive search of dividing n nodes into k **clusters. This defeats the** purpose of developing the fast agglomerative clustering step. Instead, we look only at the boundary nodes, i.e., the nodes that have at least one neighbor in another cluster.

Initially the set of all the boundary nodes is identified. We use an n × k **matrix to keep**
track of the neighborhood information of the boundary nodes. If B **denotes this matrix, and** I denotes an n**-dimensional vector:**

$$B(u,i)=\left\{\begin{array}{ll}\sum_{v\in C_{i}}w(u,v)&\mbox{if$u\not\in C_{i}$}\\ 0&\mbox{otherwise}\end{array}\right.,\ I(u)=\sum_{v\in C_{i}}w(u,v)\ \mbox{if$u\in C_{i}$}.\tag{7}$$

For each of the boundary nodes, improvements in normalized association by moving from their current cluster to each of their neighbors are calculated. This improvement for node u moving from cluster i **to cluster** j is

$$\delta(u,i,j)=\frac{w(C_{i},C_{i})-2I(u)}{d(C_{i})-d(u)}+\frac{w(C_{j},C_{j})+2B(u,j)}{d(C_{j})+d(u)}\tag{8}$$ $$-\left(\frac{w(C_{i},C_{i})}{d(C_{i})}+\frac{w(C_{j},C_{j})}{d(C_{j})}\right).$$

If no move leads to improvement, the node stays in the cluster to which it belongs. If one or more moves result in improvement, then the node is moved to the cluster that results