to find a near-optimal solution. Hence, as a part of the SAT encoding of a cube, all the subsequent experiments assume that constraint condition of twophase algorithm is add to the SAT encoding of Rubik's Cube. Table 1 presents the numbers of variables and clauses required to encode Rubik's Cube by our encoding strategy. Here, the length of a solution is limited to be 20. So all the numbers of clauses required are small, and are within 6700, although **they have** a little bit change for different lengths of the phase 1 maneuvers.

Table 1. **Numbers of variables and clauses required to encode Rubik's Cube**
with different lengths of the phase 1 maneuvers

| length of phase 1   | number of variable   | number of clauses   |
|---------------------|----------------------|---------------------|
| 9                   | 3570                 | 66028               |
| 10                  | 3570                 | 66026               |
| 11                  | 3594                 | 66201               |
| 12                  | 3618                 | 66248               |

The time to solve a cube greatly depends on the given states. The cube state shown in Figure 1 is an easy example. We found the following six solutions to this example by setting different faces to the U- and D**-face, and using different** encoding strategies, based on two-phase algorithm.

1. F2RDF′R′D2UL′**DF L**2UR2D2L2U
′L2B2F2R2 2. R′**F RBU**′B′D′LU′F
′U
′R2B2U
′B2L2U2L2D2F2 3. F
′L
′F
′U2BU′F
′DF2LB2R2D2F2R2F D2B′F2U2 4. UF′RL′B2F2LBD′B′RB2LB2LD2B2L
′B2U2 5. UF′D2U2R′L2F U′F
′RF2R′L2D2LF2D2R′B2U2 6. **UF R**2LB2F2L
′B′U
′B′RD2B2D2B2U2L2B2R′L
′
Each solution took about 200 seconds. These solutions have a common characteristic: both the length of the phase 1 maneuvers and the length of the phase 2 maneuvers are 10, and the total length is 20. These solutions are **not the shortest. Finding a shorter solution will take much more time, since the length of the**
phase 1 maneuvers increases with the shortening of solutions.

A special cube state which flips all 12 edges, called superflip, is a hard **example**
to our SAT solver. It has been proven to have a shortest maneuver length of 20 moves to be solved. Finding a shortest solution to the superflip is timeconsuming. However, it is easy to find a near-optimal solution. Actually, we took 532 seconds to find a solution with the length of 21 moves as follows.

BF′L
′U2F2LD′U
′F
′R′LF2U2R2B2UR2D′B2U
′R2 If the length of the phase 1 maneuvers is known to be 13 in advance, **for the**
superflip, we can find easily a shortest solution of length 20 as follows.

BF U2R′D′UL2B2R2B′U2R′L
′U
′L2U
′B2D′L2U
′
It took about 310 seconds. Note that this solution is different from **that given**
by Cube Explorer [16] that implements two-phase algorithm using lookup tables.