Some two-move sequences will yield the same result. For example, two-moves UD and DU **have the same result states. To speed up the search, we remove** the search on two-move sequences such as DU**. The removing of such a search**
can be done by adding the following constraint clauses to the SAT encoding of Rubik's Cube.

V
1≤k≤n
((uk ∨ dk+1) ∧ (lk ∨ rk+1) ∧ (fk ∨ bk+1))

## 7 4 Encoding Kociemba'S Algorithm And Other Constraints

Using the SAT encoding given in the previous section, a modern SAT solver can find only solutions of length at most 13. However, many states have already been shown that requires 20 moves (e.g. superflip). To find such a solution, we add other tricks. A useful trick is to add the encoding of Kociemba's **algorithm,** which is a two-phase algorithm. The basic idea of the algorithm is to splits the problem into two almost equal subproblems, each of which can use a lookup table to search for exhaustively a solution. Here is the pseudo-code of Kociemba's algorithm.

## Kociemba'S Algorithm

d ← 0, t ← ∞
while **d < t** do for s ∈ S
d 18, ps ∈ H do if d + D(ps) < t **then**
find a better solution, using moves in A10 t ← d + D(ps)
end if end for d ← d + 1 end while This algorithm assumes that the original state is p**, and applies some move**
sequence s ∈ S
d 18 (for the definition of S18, see Section 2) of length d **to the**
original cube yielding ps which lies in H**. This search process is called phase** one. Here H **is a subset of states that is composed of all patterns with following** characteristics:
1. The orientation of all corner cubies and edge cubies is correct.

2. The edge cubies that should be in the middle layer are now located in the middle layer.

These characteristics are preserved by moves in the set A10 **(which is defined**
in Section 2). The search process from the new state ps **to the fully solved state is**
called Phase two. In this phase, each move is in A10. D(ps**) returns the distance** from the state ps to the solved state using moves in A10**. To efficiently complete**
this computation, it is usually done by a lookup table. In fact, Phase one is usually also done by a lookup table.