# The Hidden Web, Xml And The Semantic Web: Scientific Data Management Perspectives

Fabian M. Suchanek *
Aparna S. Varde INRIA Saclay Paris France Dept. of Computer Science, Montclair State University Montclair, NJ
USA
vardea@xmontclair.edu fabian@xsuchanek.name

## Abstract

The World Wide Web no longer consists just of HTML pages. 

Our work sheds light on a number of trends on the Internet that go beyond simple Web pages. The hidden Web provides a wealth of data in semi-structured form, accessible through Web forms and Web services. These services, as well as numerous other applications on the Web, commonly use XML, the eXtensible Markup Language. XML has become the *lingua franca* of the Internet that allows customized markups to be defined for specific domains. On top of XML, the Semantic Web grows as a common structured data source. In this work, we first explain each of these developments in detail. Using real-world examples from scientific domains of great interest today, we then demonstrate how these new developments can assist the managing, harvesting, and organization of data on the Web. On the way, we also illustrate the current research avenues in these domains. We believe that this effort would help bridge multiple database tracks, thereby attracting researchers with a view to extend database technology. 

## Categories And Subject Descriptors

H.2.8 [Database Management]: Database Applications - Scientific databases, H.3.3. [Information Search and Retrieval] - Search process

## General Terms

Design, Human Factors, Performance

## Keywords

Deep Web, Domain-Specific Markup Languages, Hidden Web, Multidisciplinary work, Scientific data, Semantic Web, XML.

## 1. Introduction 1.1 Background And Motivation

The Web has revolutionized the way we seek information. It covers domains as diverse as education, entertainment, business, Permission to make digital or hard copies of all or part of this work for personal or classroom use is granted without fee provided that copies are not made or distributed for profit or commercial advantage and that copies bear this notice and the full citation on the first page. To copy otherwise, to republish, to post on servers or to redistribute to lists, requires prior specific permission and/or a fee.

EDBT 2011, March 22-24, 2011, Uppsala, Sweden. Copyright 2011 ACM 978-1-4503-0528-0/11/0003 ...$10.00.

Richi Nayak Computer Science Discipline, Queensland University of Technology Brisbane, Australia

## R.Nayak@Xqut.Edu.Au

Pierre Senellart *
Institut Télécom; Télécom Paristech; CNRS LTCI
Paris France

## Pierre@Xsenellart.Com

and even health. It has evolved into a publishing medium, a global information repository and a global electronic market. From a user's perspective, the Internet is mainly a source of Web pages. Yet, there is much more to the Web than HTML pages. Much of its content lies in databases behind the Web. This content, called the hidden Web, is accessible only through Web forms or through specific Web services. It is estimated that the hidden Web contains orders of magnitude more data than the visible Web. Yet, despite its providing structured data, it is not obvious how to access this data by a machine. In order to make use of this wealth of information, Web forms have to be found and filled in, and the requested answers have to be analyzed and understood. Through the medium of this tutorial, we show the newest research trends in the area of the hidden Web and tell the story of various early successes. We also focus on the Web developments in two other exciting areas, namely XML and the Semantic Web. The increasing use of XML is an interesting trend on the Web. XML, the Extensible Markup Language, is a W3C standard for the exchange of semi-structured data. Through XML, it has become possible to transfer data between systems as diverse as databases, Web services, semantic knowledge bases or end user applications in one common file format. Yet, XML by itself defines just the abstract syntax, the hull of the information. It does not standardize the semantics or the structure of the data. This is the role of domain-specific markup languages (DSMLs). In this tutorial, we explain the design principles of DSMLs and how they blend into XML. We first give an overview of the most established DSMLs, thereby diving into the realm of real-world XML as it is used on the Web. We then also show how various mining techniques can be applied to XML data for better knowledge discovery. The latest development on the Web is the Semantic Web - the newly growing structure of computer-processable meaningful information. With its W3C standards RDF and OWL, the Semantic Web aims to unify the way semantic information is stored and exchanged, making it possible for one system to not just read, but also ―understand‖ the data from another source. Our tutorial provides basic literacy with these standards. We also show where the Semantic Web has already taken off - with example knowledge bases from the science domain, the music domain or indeed general common sense knowledge. Still, the Semantic Web is in its infancy. Numerous challenging research questions, e.g., in areas of information reconciliation and knowledge representation, still long to be answered. * The work was partially funded by the ERC grant Webdam.