
## 1.2 Goals

The overall goal of this tutorial is to show how all these diverse trends can be used for data management. As an example, we choose the scientific domain. Interdisciplinary research has attracted tremendous interest in recent years with the emerging need for computer scientists to work across domains. This has led to significant development of techniques and standards that use computational principles to solve challenging real-world problems in specific domains, with new theories being proposed as needed. In the last decade, a large part of this research has occurred in the field of scientific domains. Management of scientific data has accordingly become an exciting interdisciplinary field of study. Moreover, in this age of globalization, it is imperative to share the information with communities of scientists and related professionals from all over the world through the Web. We therefore shed light on new methods of scientific data management on the Web. On the way, we illustrate the various research questions in these domains that are still unanswered. We aim to use various examples from scientific data throughout including markup languages specifically developed for scientific domains. For instance, we show how data about Cédric Villani (recipient of the Fields Medal 2010) and his works can be stored and retrieved using each of these technologies. Data on his research, not so obvious from the surface Web, can be found using intentional and extensional approaches in the hidden Web. Meaningful data extraction about him, including personal information that requires some human reasoning, can be carried out using Semantic Web technologies. XML and its domainspecific markup languages such as MathML, can store additional information, such as mathematical data, in an expressive Webbased format. 

These technologies are by no means finalized. This tutorial thus endeavors to highlight the open issues in these domains and point out the hot spots of today's research. It would thus encourage future work across these areas, opening new avenues for research and development, especially propelling further research in areas that blend these technologies.

## 1.3 Outline

This tutorial is organized in three parts, each one focusing on one aspect of scientific data management. The first part delves into the hidden Web (also known as the deep Web or invisible Web), explaining how it can be used for storing and retrieving scientific information. The second part focuses on XML data management along with domain-specific markup languages (DSMLs), particularly with respect to modeling and mining scientific data. The third part presents the details of the Semantic Web with emphasis on its usefulness for managing scientific data. 

## 2. Scientific Data Management 2.1 The Hidden Web

It is impossible to reach the whole content of the World Wide Web by just following hyperlinks. Rather, some Web pages create their content on demand if the user fills out and submits a Web form. These forms are typically interfaces to databases stored on Web servers, which are usually not directly accessible. A reason behind this may be that the Web site owner wants to keep control on how the information is accessed. Some hidden Web pages are ―Yellow pages‖ services and other kinds of directories; others are library catalogs, weather forecast services, geo-localization services, commercial product catalogs or administrative sources such as the database of the United States census bureau. As an example in the scientific data management domain, let us consider the following task: ―Retrieve all articles published by Cédric Villani.‖ This information is most likely available from the surface Web, but a classical Web crawler would have to explore a large number of documents, and then use some heuristics or classification techniques to determine the relevant ones. This is a time-consuming and imprecise process. On the other hand, using services of the hidden Web, this becomes a very simple task: simply use the advanced querying capabilities of a publication database, such as Google Scholar. The question is how users can benefit from this vast source of information. How can they discover it, index it, and be able to use it automatically for a given task? We review some ways to tackle these challenges. We focus here especially on unsupervised and semi-supervised approaches for knowledge discovery over the hidden Web such as [11], more adapted to the scale and diversity of the Web than supervised methods. Most current approaches can be roughly classified [9] into extensional or *surfacing* strategies (retrieving information from the hidden Web and storing it locally to process it) and intentional or *integration* strategies (analyzing services to understand their structure, store this description, and use it to forward users' queries to the services). By covering these two avenues, we give an overview of the most important current approaches of data management on the hidden Web.

## 2.2 Xml And Dsmls

With the continuous growth in XML-based data sources, especially in scientific applications, the ability to manage collections of XML documents becomes increasingly important [7]. In such applications, it is useful to capture the reasoning process of domain experts, especially in modeling and mining the data. Modeling of XML documents, which are semistructured, requires finer details than unstructured (text) 
documents and fully structured documents. XML allows the representation of semi-structured and hierarchal data containing not only the values of individual items but also the relationships between data items. Due to the inherent flexibility of XML, in both structure and semantics, mining of XML documents significantly differs from structured data mining and text mining [6]. Consequently, management of XML data is faced with new challenges as well as benefits [10,14]. A considerable advancement in the general area of XML is the advent of domain-specific markup languages (DSMLs). These languages are designed such that they follow the syntax of XML and encapsulate the semantics of the concerned domain in order to cater to the needs of targeted user bodies. Accordingly, they serve as communication standards in the respective domains. The storage of data in this format has several advantages such as more meaningful information retrieval and knowledge discovery. This is particularly useful in scientific applications where it is crucial to incorporate the domain experts' perspective in various realworld situations.

We discuss the issues in managing XML-based scientific data. We address XML modeling and mining, focusing on both structure as well as content of XML documents. We give details such as vector, tensor, tree and graph structure representation for XML 