data, and their usefulness in scientific data management. We cover DSMLs with emphasis on scientific domains, giving illustrative examples from MML (Medical Markup Language) [5] and MathML (Mathematical Markup Language) [3]. We explain the steps in DSML development [15], the desired properties of DSMLs, and the application of XML constraints to preserve semantic restrictions [4]. Furthermore, we describe how the XML model used for data storage facilitates information retrieval with languages in the XML family such as XQuery [2]. We also explain the advantages of using classical data mining techniques such as association rules and clustering over XML documents in conjunction with DSMLs to enhance knowledge discovery, especially from scientific data. Suitable examples from domains such as medicine are provided here [8,15]. Finally, open research questions are addressed pertaining to structure and content mining and a greater synergy between XML and DSMLs.

## 2.3 Semantic Web Technologies

The Semantic Web project envisions that people will publish semantic information in a computer-processable formalism that allows the information to be globally interlinked. For this purpose, the World Wide Web Consortium (W3C) has developed the knowledge representation formalisms RDF [18] and OWL [17]. These formalisms are based on XML, but go beyond it by specifying semantic relationships between entities and even logical constraints on them. A collection of world knowledge in these formalisms is commonly called an *ontology* [12]. In this tutorial, first give an introduction to semantic knowledge representations and ontologies in general. We also explain the knowledge representation formalisms RDFS and OWL, their syntax and semantics. We explain the vision and the applications of the Semantic Web project. We then show how the Semantic Web can be used for scientific data management. We introduce different existing semantic resources for scientific data, from publication databases such as DBLP, which have been published in RDF, to general purpose ontologies such as YAGO [13] or DBpedia [1], each containing thousands of scientists and scientific concepts and theories. Several large-scale ontologies are available online and are interlinked in the spirit of the Semantic Web. We also explain how this information was gathered from different sources and how it can be queried using the SPARQL query language [19]. 

## 3. Challenges

We highlight some of the challenging issues leading to current research questions in each of these Web developments addressed in this work. In the area of the hidden Web, although there are techniques to derive the type of input parameters and output records of a Web form, it is still challenging to get the precise semantics of a service. If a service, given a person, returns a year, how do we know whether this is the birth date, death date, or graduation date? Moreover, dealing with complex forms (such as those used to access specialized scientific databases), especially when there are dependencies between form fields, required and optional fields, etc., is a fully open problem by itself. Finally, a knowledge discovery system for the hidden Web that would not cover 

specific Web sites or a specific domain of interest but would work at the scale of the whole Web is still to be constructed. In the area of XML and DSMLs, some of the current issues and challenges in managing scientific data are:
1. Effectively modeling both structure and content features for XML documents to adequately represent scientific data and investigating how DSMLs can be useful here 2. Combining structure and content features in different types of data models which do not affect the *scalability* of the mining process 3. Integrating background knowledge of scientific processes in XML mining *algorithms* and harnessing DSMLs here 4. Developing new standards as needed especially to foster knowledge discovery by synergizing XML and DSMLs The Semantic Web is still relatively young. Numerous challenges still wait to be solved:
1. One of the main open research questions is the reconciliation of different semantic conceptualizations in different ontologies. Techniques such as record linking and matching carry over from the database world, but present themselves in the new light of the Semantic Web, with more information and constraints available to support the mapping process. 

2. Another challenge is the growing of the Semantic Web - be it through community work, by converting existing databases into RDF, or by Information Extraction.

3. Reasoning on Web scale is likewise still an open issue. How can we apply automated reasoners on huge, potentially noisy data sets?

4. The Semantic Web can also be mined, for example to find sub- and super-class relationships or to find schema information.

With the presentation of these challenges, we aim at encouraging even more research in the areas of the hidden Web, XML, and the Semantic Web, to further enhance scientific data management. 

## 4. Conclusions

This tutorial would show that developments in the areas of the hidden Web, Semantic Web, XML and DSMLs have influenced the current state of the Web by improving the way different computer applications and services communicate, and relevant information is identified, especially in scientific domains. Most of the data on the Web is so unstructured that only humans can understand it. However, the volume of the data is so huge that only machines can process it. This paradox highlights the importance of techniques ―in between‖ the extremes: semistructured languages such as XML, the Semantic Web and the hidden Web. This tutorial sees itself as an invitation to researchers to make use of these technologies on one hand - and to contribute to these developments on the other hand. We believe that there is exciting research potential in bridging the different new developments on the Web.

## 5. Author Biographies

Fabian Suchanek is a postdoctoral researcher at INRIA Saclay in Paris. He spent one year as a visiting researcher at Microsoft Research Silicon Valley. Fabian obtained his doctoral degree at the Max Planck Institute for Informatics/Germany in 2008. In his 