# Probabilistic Inference From Arbitrary Uncertainty Using Mixtures Of Factorized Generalized Gaussians

Alberto Ruiz ARUIZ@DIF.UM.ES
Pedro E. López-de-Teruel PEDROE@DITEC.UM.ES
M. Carmen Garrido MGARRIDO@DIF.UM.ES
Universidad de Murcia, Facultad de Informática, Campus de Espinardo, 30100, Murcia, Spain

## Abstract

This paper presents a general and efficient framework for probabilistic inference and learning from arbitrary uncertain information. It exploits the calculation properties of finite mixture models, conjugate families and factorization. Both the joint probability density of the variables and the likelihood function of the (objective or subjective) observation are approximated by a special mixture model, in such a way that any desired conditional distribution can be directly obtained without numerical integration. We have developed an extended version of the expectation maximization (EM) algorithm to estimate the parameters of mixture models from uncertain training examples (indirect observations). As a consequence, any piece of exact or uncertain information about both input and output values is consistently handled in the inference and learning stages. This ability, extremely useful in certain situations, is not found in most alternative methods. The proposed framework is formally justified from standard probabilistic principles and illustrative examples are provided in the fields of nonparametric pattern classification, nonlinear regression and pattern completion. Finally, experiments on a real application and comparative results over standard databases provide empirical evidence of the utility of the method in a wide range of applications.

## 1. Introduction

The estimation of unknown magnitudes from available information, in the form of sensor measurements or subjective judgments, is a central problem in many fields of science and engineering.

To solve this task, the domain must be accurately described by a model able to support the desired range of inferences. When satisfactory models cannot be derived from first principles, approximations must be obtained from empirical data in a learning stage.

Consider a domain Z composed by a collection of objects z =(z 1, z 2, ..., z n), represented by vectors of n attributes. Given some partial knowledge S (expressed in a general form explained later) about a certain object z, we are interested in computing a good estimate zˆ(S), close to the true z. We allow heterogeneous descriptions; any attribute z i may be continuous, discrete, or symbolic valued, including mixed types. If there is a specific subset of unknown or uncertain attributes to be estimated, the attribute vector can be partitioned as z = (*x, y*), where y ⊆ z denotes the target or output attributes. The target attributes can be different for different objects z. This scenario includes several usual inference paradigms. For instance, when there is a specific target symbolic attribute, the task is called pattern recognition or *classification*; when the target attribute is continuous, the inference task is called regression or *function approximation*. In general, we are interested in a general framework for *pattern completion* from partially known objects.

Example 1: To illustrate this setting, assume that the preprocessor of a hypothetical computer vision system obtains features of a segmented object. The instances of the domain are described