
## 4. Learning From Uncertain Information

In the previous section, we have described the inference process from uncertain information under the MFGN framework. Now we will develop a learning algorithm for the model of the domain, where the training examples will be also uncertain. Specifically, we must find the parameters Pi
,
µi j, σi j(or j i t,ω
) of a mixture with structure (7) to approximate the true joint density p(z) from a training i.i.d. random sample {z
(k)}, k=1..M, partially known through the associated likelihood functions {S
(k)} with structure (9).

## 4.1 Overview Of The Em Algorithm

Maximum Likelihood estimates for the parameters of mixture models are usually computed by the well-known Expectation-Maximization (EM) algorithm (Dempster, Laird and Rubin 1997, Redner and Walker 1984, Tanner 1996), based in the following idea. In principle, the maximization of the training sample likelihood J pkk
= Π ( )
( )
z is a mathematically complex task due to the product of sums structure. However, note that J could be conveniently expressed for maximization if the components that generated each example were known (this is called "complete data" in EM terminology). The underlying credit assignment problem disappears and the estimation task reduces to several uncoupled simple maximizations. The key idea of EM is the following: instead of maximizing the complete data likelihood (which is unknown), we can iteratively maximize its expected value given the training sample and the current mixture parameters. It can be shown that this process eventually achieves a local maximum of J.

Instead of a rigorous derivation of the EM algorithm, to be found in the references (see especially McLachlan and Krishnan, 1997), we will present here a more heuristic justification which provides insight for generalizing the EM algorithm to accept uncertain examples. We will review first the simplest case, where no missing or uncertain values are allowed in the training set. The parameters of the mixture are conditional expectations:

$$\operatorname{E}_{z|C_{i}}\{g(z)|C_{i})\}=\int_{Z}g(z)\,p(z|C_{i})\,d z$$
$$(20)^{\frac{1}{2}}$$

g C = g p C d ∫(20)
In particular, $\mu_{i}^{j}=\mathds{E}\{z^{i}|C_{i}\}\,,\ (\sigma_{i}^{j})^{2}=\mathds{E}\{(z^{i}-\mu_{i}^{j})^{2}|C_{i}\}$ and $t_{i,\omega}^{j}=\mathds{E}\{I\{z^{j}=\omega\}|C_{i}\}\,.$ The 
mixture proportions are Pi = E Ci
{ P{ |z}}.

We rewrite the conditional expectation (20) using Bayes Theorem in the form of an unconditional expectation:

$$\operatorname{E}_{z|C_{i}}\{g(z)|C_{i}\}\,\}=\int_{z}g(z)\operatorname{P}\{C_{i}|z\}\,p(z)\,/\operatorname{P}\{C_{i}\}\,d z\,=$$
g C = g C p C d ∫= (21)
$$(21)^{\frac{1}{2}}$$
$$=\operatorname{E}_{z}\{g(z)\operatorname{P}\{C_{i}|z\}\}\,/\,P_{i}$$
|z}} / Pi(22)
The EM algorithm can be interpreted as a method to iteratively update the mixture parameters using expression (22) in the form of an empirical average over the training data 4. Starting from a tentative, randomly chosen set of parameters, the following E and M steps are repeated until the 4 Expression (21) can be also used for iterative approximation of explicit functions which are not indirectly known by i.i.d. sampling (e.g., subjective likelihood functions sketched by the human user, as in Example 4). In this case p(z) is set to the target function and P{Ci| z} is computed from the current mixture model.

$$(22)$$
