EM is compared with the EM algorithm over the "raw" observations (Basic EM), which ignores the likelihood function and typically uses just its average value (e.g., given x≅8±2, Basic EM uses x=8). We considered a synthetic 3-attribute domain with the following joint density:
p(x,y,w) = 0.5 T(x,0,2) T(y,0,1) T(*w,white*)
 + 0.5 T(x,2,1) T(y,2,2) T(w,*black*)
Different learning experiments were performed with varying degrees of uncertainty. In all cases the training sample size was 250. All trained models had the same structure as the true density (2 components), since the goal of this experiment is to measure the quality of the estimation with respect to the amount of uncertainty, without regard of other sources of variability such as local minima, alternative solutions, etc., which are empirically studied in Section 5. Table 6 shows the mixture parameters obtained by the learning algorithms. Fig. 18 graphically shows the difference between Extended and Basic EM in some illustrative cases.

Case 0: Exact Data (Fig. 18.a). Cases m %: Results of the Extended EM learning algorithm when there is a m % rate of missing values in the training data.

Case 1: Basic EM when attribute y is biased +3 units with probability 0.7. **Case 2**: Extended EM
algorithm over Case 1 (see Fig. 18.b). Here, the observed value is sy=y+3 in 70% of the samples and sy=y in the rest. In all samples, Basic EM uses the observed value sy and Extended EM uses the explicit likelihood function f(y) = 0.3 δ(y–sy) + 0.7 δ(*y–(s*y–3)).

Case 3: Basic EM when attributes x and y have Gaussian noise with σ = 0.5 and w is changed with probability 0.1. **Case 4**: Extended EM algorithm over Case 3.

Case 5: Basic EM when x and y have Gaussian noise with σ = 1 and w is changed with probability 0.2. **Case 6**: Extended EM algorithm over Case 5 (see Fig. 18.c).

Case 7: Basic EM when x and y have Gaussian noise with σ = 2 and w is changed with probability 0.3. **Case 8**: Extended EM algorithm over Case 7 (see Fig. 18.d).

Case 9: Extended EM when values y>3 are missing (*censoring*). **Case 10**: Extended EM over Case 9 when the missing y values are assumed to be distributed as T(y, 4, 1), providing some additional information on the data generation mechanism.

Table 6 and Fig. 18 confirm that for small amounts of deterioration in relation to the sample size, the estimates computed by the basic EM Algorithm over the "raw" observed data are similar to those obtained by the Extended EM algorithm (e.g., Cases 3 and 4). However, when the data sets are moderately deteriorated the true joint density can be correctly recovered by Extended EM using the likelihood functions of the attributes instead of the raw observed data (e.g., Cases 5 and 6, Fig.

18.c). Finally, when there is a very large amount of uncertainty with respect to the training sample size the true joint density cannot be adequately recovered (e.g., Cases 7 and 8, Fig. 18.d).