simple and unified way, for heterogeneous attribute sets. It is not necessary to provide models for uncertain attribute correlations since no covariance parameters must be estimated. Finally, the training sample size must be large enough in relation to both the degree of uncertainty of the examples and the complexity of the joint density model in order to obtain satisfactory approximations.

On the other hand, the number of mixture components required for a satisfactory approximation to the joint density must be specified. A pragmatic option is the minimization of the experimental estimation cost over the main inference task, if it exists. For instance, in regression we could increase the number of components until an acceptable estimation error is obtained over an independent data set (cross-validation). The same idea applies to pattern classification: use the number of components that minimizes the error rate over an independent test set. However, one of the main advantages of the proposed method is the independence between the learning stage and the inference stage, where we can freely choose and dynamically modify the input and output role of the attributes. Therefore, a global validity criterion is desirable. Some typical validation methods for mixture models are reviewed in McLachlan & Basford (1988); the standard approach is based on likelihood ratio tests on the number of components. Unfortunately, this method does not validate the mixture itself, only selects the best number of components (DeSoete 1993).

Since the MFGN framework provides an explicit expression for the model p(z), we can apply statistical tests of hypothesis over an independent sample T taken from the true density (e.g. a subset of the examples reserved for testing) to find out if the obtained approximation is compatible with test data. If the hypothesis H = {T comes from p(z)} is rejected, then the learning process must continue, possibly increasing the number of components. It is not difficult to build some statistical tests, e.g. over moments of p(z), because their sample means and variances can be directly obtained.

However, as data sets usually include symbolic and numeric variables, we have also developed a test on the expected *likelihood* of the test sample, which measures how well p(z) "covers" the examples. The mean and variance of p(z) can be easily obtained using the properties of generalized normals. Some experiments over simple univariate continuous densities show that this test is not very powerful for small sample sizes, i.e. incompatibility is not always detected, while other standard tests significantly evidence rejection. Nevertheless, clearly inaccurate approximations are detected, results improve as the sample size increases and the test is valid for data sets with uncertain values.

The Minimum Description Length (Li & Vitànyi 1993) principle can be also invoked to select the optimum number of components by trading-off the complexity of the model and the accuracy in the description of the data.