The proposed approach is closely related to a well-known family of approximation techniques which, essentially, distribute (using some kind of clustering or self-organizing algorithm) "detectors" over the relevant regions of the input space and then combine their responses for computing the desired outputs. This is the case of Radial Basis Functions (RBF) (Hertz et al.), the classification and regression trees proposed in (Breiman et al. 1984) and the topological maps used in (Cherkassky & Najafi 1992) to locate the "knots" required for piecewise linear regression.

A relevant methodology is proposed in (Jordan & Jacobs 1994, Peng et al. 1995), where the EM algorithm is used to learn hierarchical mixtures of experts in the form of linear rules in such a way that the desired posterior densities can be explicitly obtained. The properties of the EM algorithm are also satisfactorily used in (Ghahramani & Jordan 1994) to obtain unbiased approximations from missing data in a mixture-based framework similar to ours. Our framework extends this successful approach by exploiting the conjugate properties of the chosen universal approximation model: uncertain information of arbitrary complexity can be efficiently processed in the inference and learning stages.

The MFGN framework is appropriate for a moderated number of variables showing relatively complex dependencies. In contrast, Bayesian Networks satisfactorily addresses the case of a large number of variables with clear conditional independence relations. There are situations in which a certain subset of the variables in a Bayesian Network shows no explicit causal structure. This subdomain could be empirically modeled by a mixture model in order to be considered later as a composite node embedded in the whole network. If the subdomain can be conditionally isolated from the rest of variables through a set of communication nodes, the MFGN framework can be used to perform the required inferences.

Finally, mixture models are typically used for unsupervised classification: the examples are labeled with the index of the component with highest posterior probability. In fact, the MFGN
framework explicitly finds clusters in the training set. Furthermore, continuous and symbolic attributes are allowed in the joint density, so the examples are clustered using an implicit probabilistic metric which automatically weighs all the (heterogeneous) attributes, even with missing and uncertain values. However, this method is effective only when the groups of interest have the same structure as the component densities. In order to simplify inference the mixture components have been selected with constraints (Gaussian, independent variables) which are not necessarily verified by the "natural" groups found in real applications.

A tentative possibility (inspired in a common heuristic clustering technique) consists of joining overlapping components (e.g., according to the Battachariya distance, a well-known bound on the Bayes error used in Statistical Pattern Recognition (Fukunaga 1990)). Unfortunately, our experiments indicate that the overlapping threshold is a free parameter that strongly determines the quality of the results. A universal threshold, independent of the application, does not seem to exist. In principle, clusters of arbitrary geometry may be discovered, but this cannot be easily automated.

Therefore, other nonparametric cluster analysis methods (e.g. density valley seeking) are suggested for labeling complex groups.

## 5.4 Experimental Evaluation

The MFGN method has been evaluated on standard benchmarks from the Machine Learning database repository at the University of California, Irvine (Merz and Murphy 1996). It contains inductive learning problems which are representative of real world situations. We have experimented with the following databases: Ionosphere, Pima Indians, *Monk's Problems*, and *Horse Colic*, which illustrate different properties of the proposed methodology. In most cases MFGN has been compared to alternative learning methods with respect to the inference task considered of interest in