
In this problem, the plain MFGN method, without special heuristics in the learning stage, is

comparable in average to the alternative methods. The best solution on the training set (crossvalidation) is entirely satisfactory.

For the *Ionosphere* database we also present an exhaustive study of performance given varying

proportions of missing values in the training and testing examples. A value of x % means that in all

training or test examples the value of each attribute is deleted with probability x. The basic experiment consists of learning a MFGN model with the prescribed number of components (4, 8 and 15)

and computing the error rate on the training and test sets. Table 8 shows the mean value ± 2 standard deviations of the error rates obtained in 10 repetitions of the basic experiment in each configuration. Column M contains the error rate of each configuration over its own training set. The training/test partition is kept fixed to analyze the variability of the solutions due to random initialization

of the EM.

LEARNING **INFERENCE**

M 0% 10% 25% 50%

4 COMP. - 0% 22 ± 15 21 ± 8 21 ± 8 22 ± 8 22 ± 9 8 COMP. - 0% 11 ± 6 13 ± 6 12 ± 6 13 ± 5 12 ± 6 15 COMP. - 0% 10 ± 5 13 ± 6 13 ± 6 13 ± 5 13 ± 4 4 COMP. - 10% 21 ± 14 23 ± 11 23 ± 11 23 ± 11 23 ± 11 8 COMP. - 10% 11 ± 3 13 ± 5 12 ± 5 13 ± 5 13 ± 4 15 COMP. - 10% 10 ± 3 12 ± 6 12 ± 7 12 ± 6 12 ± 3 4 COMP. - 25% 18 ± 7 19 ± 5 19 ± 5 18 ± 6 18 ± 6 8 COMP. - 25% 12 ± 7 14 ± 10 14 ± 9 15 ± 8 14 ± 7 15 COMP. - 25% 9 ± 5 12 ± 9 13 ± 11 13 ± 9 13 ± 7 4 COMP. - 50% 27 ± 18 26 ± 15 27 ± 15 27 ± 14 26 ± 13 8 COMP. - 50% 16 ± 12 21 ± 15 21 ± 15 21 ± 13 20 ± 11 15 COMP. - 50% 13 ± 6 26 ± 17 25 ± 15 25 ± 14 23 ± 13

Table 8. Evaluation of MFGN on *Ionosphere* Database given

different proportions of missing data in the training and testing subsets.

As expected, the MFGN model is robust with respect to large proportions of missing values in the test patterns, and to moderated proportions of missing data in the training set. We have compared the above behavior with a standard algorithm for Decision Tree construction inspired in
(Quinlan 1993), which is also able to support missing values 8. Table 9 shows the error rates of the decision trees for the same experimental setting as in Table 8. This kind of Decision Tree obtains error rates that are better than the averages obtained by MFGN. However, MFGN's best solutions (selected by cross-validation) are better than the ones obtained by Decision Tree. Furthermore, Decision Tree performance degrades faster than MFGN, especially with respect to the proportion of missing values in the inference stage.