
## 5.4.5 Comments

The above experiments demonstrate that the MFGN model is able to obtain acceptable results on many real world applications. In particular, the error rates obtained in standard classification tasks are comparable to those obtained by other popular learners. Additionally, MFGN is able to perform inferences over any other attribute given uncertain or partial information, which is not possible for most of the alternative methods. This property makes MFGN a very attractive alternative for many inference problems such as the one illustrated in Example 16. The experiments have also contributed to characterize the kind of problems for which the MFGN model is best suited. Essentially, the relationship among attributes must be of a true probabilistic nature, and the attribute vector must be of a moderated size containing "relevant" variables. A previous feature selection / accommodation stage is recommended in certain applications.

## 6. Conclusions

We have developed an efficient methodology for probabilistic inference and learning from uncertain information. Under the proposed MFGN framework, the joint probability density function of the attributes and the likelihood function of the available information are approximated by Mixtures of Factorized Generalized Normals. This mathematical structure allows efficient computation, without numerical integration, of posterior densities and expectations of the desired variables given events of arbitrary "geometry". An extended version of the EM learning algorithm has been developed to estimate the parameters of the required mixture models from uncertain training examples.

Different paradigms as pattern recognition, regression or pattern completion are subsumed under a common framework.

A comprehensive collection of examples illustrates the methodology, which has been critically compared with alternative techniques. The Extended EM algorithm is able to learn satisfactory domain models from a reasonable number of examples with uncertain values, taking into account the explicit likelihood functions of the available information. Results are satisfactory whenever the sample size is large in relation to the amount of (known) degradation of the training set. The experiments also characterized the kind of situations that the model manages better: Domains described by a moderate number of heterogeneous attributes with complex probabilistic dependences, problems in which the output variables are not necessarily known in the learning stage (i.e. pattern completion), and, finally, problems in which an explicit management of uncertainty is needed, either in the learning or in the inference stage (or even in both). The MFGN framework has obtained a very favorable trade-off between useful features and model complexity in the solutions to different applications and benchmarks.

Future developments of our work include improving the learning stage with some heuristic steps that are combined with the standard E and M steps to control the adequacy of the acquired models. Additional studies are required on validation tests, generalization, scalability, robustness and data preprocessing. The essential idea of working with explicit likelihood functions will be incorporated into the Parzen approximation scheme and we are also interested in more expressive model structures such as mixtures of factor analyzers, principal component analyzers or linear experts. Finally, the methodology can be developed in a pure Bayesian framework or subsumed under the Dempster-Shafer Evidence Theory.