

![0_image_0.png](0_image_0.png)

The decomposition of probability distributions using mixtures has been frequently applied to unsupervised learning tasks, especially Cluster Analysis (McLachlan & Basford 1988, Duda &
Hart 1973, Fukunaga 1990): the *a posteriori* probabilities of each postulated category are computed for all the examples, which are labeled according to the most probable source density. However, mixture models are specially useful in nonparametric supervised learning situations. For instance, the class conditional densities required in Statistical Pattern Recognition were individually approximated in (Priebe & Marchette 1991, Traven 1991) by finite mixtures; hierarchical mixtures of linear models were proposed in (Jordan & Jacobs 1994, Peng et. al 1995); mixtures of factor analyzers have been developed in (Ghahramani & Hinton 1996, Hinton, Dayan, & Revow 1997) and mixture models have been also useful for feature selection (Pudil et al. 1995). Mixture modeling is a growing semiparametric probabilistic learning methodology with applications in many research areas (Weiss & Adelson 1995, Fan et al. 1996, Moghaddam & Pentland 1997).

This paper introduces a framework for probabilistic inference and learning from arbitrary uncertain data: any piece of exact or uncertain information about both input and output values is consistently handled in the inference and learning stages. We approximate both the joint density p(z)
(model of the domain) and the relative likelihood function p(S|z) (describing the available information) by a specific mixture model with factorized conjugate components, in such a way that numerical integration is avoided in the computation of any desired estimator, marginal or conditional density.

The advantages of modeling arbitrary densities using mixtures of natural conjugate components were already shown in (Dalal & Hall 1983), and, recently, inference procedures based in a similar idea have been proposed in (Ghahramani & Jordan 1994, Cohn et al. 1996, Peng et al. 1995, Palm 1994). However, our method efficiently handles uncertain data using explicit likelihood functions, which has not been extensively used before in Machine Learning, Pattern Recognition or related areas. We will follow standard probabilistic principles, providing natural statistical validation procedures.

The organization of the paper is as follows. Section 2 reviews some elementary results and concepts used in the proposed framework. Section 3 addresses the inference stage. Section 4 is concerned with learning, extending the EM algorithm to manage uncertain information. Section 5 discusses the method in relation to alternative techniques and presents experimental evaluation.

The last section summarizes the conclusions and future directions of this work.