
## 2. Preliminaries 2.1 A Calculus Of Generalized Normals

In many applications, the instances of the domain are represented simultaneously by continuous and symbolic or discrete variables (as in Wilson & Martinez 1997). To simplify notation, we will denote both probability impulses and Gaussian densities by means of a common formalism. The generalized normal T(x,µ,σ) denotes a probability density function with the following properties:

$${\mathcal{N}}(x,\mu,\sigma)\equiv{\frac{1}{\sqrt{2\pi\sigma}}}e x p\left[{\frac{-(x-\mu)^{2}}{2\sigma^{2}}}\right]$$
$$\operatorname{If}\sigma>0,$$
If σ > 0, T(x,µ,σ) ≡
$${\mathcal{N}}(x,\!\!\mu,\!\sigma)={\mathcal{N}}(x,\!\!\mu,\!0)\equiv{\mathcal{N}}(x,\!\!\mu)\equiv\delta(x\!\!\!-\!\!\mu)$$
If $\mathfrak{o}=0$, . 
If σ = 0, T(x,µ,σ) = T(x,µ,0) ≡ T(x,µ) ≡ δ(x–µ)
T(x,µ,σ) is a Gaussian density with mean µ and standard deviation σ ≥ 0. When the dispersion is zero, T reduces to a Dirac's delta function located at µ. In both cases T is a proper p.d.f.:
X
∫ T(x,µ,σ) dx = 1 T(x,µ,σ) > 0 The product of generalized normals can be elegantly expressed (Papoulis 1991 pp. 258, Berger 1985) by:
for σ1+σ2 >0: T(x,µ1,σ1) · T(x,µ2,σ2) = T(x,η,ε) · T(µ1,µ2, σ1 σ

$$(x,\eta,\varepsilon)\cdot{\mathcal{N}}(\mu_{1},\mu_{2},{\sqrt{\sigma_{1}^{2}+\sigma_{2}^{2}}}\,)\qquad\qquad(2)$$

where the mean η and dispersion ε of the new normal are given by:

$$\eta=\frac{\sigma_{1}^{2}\mu_{2}+\sigma_{2}^{2}\mu_{1}}{\sigma_{1}^{2}+\sigma_{2}^{2}}\qquad\qquad\varepsilon^{2}=\frac{\sigma_{1}^{2}\sigma_{2}^{2}}{\sigma_{1}^{2}+\sigma_{2}^{2}}$$
$$\bigcup_{x}{\mathcal{N}}(x,\mu_{1},$$
$\mathcal{F}\to\mathcal{F}^{\prime}$ 3. 
$\eqref{eq:walpha}$. 
$\square$
$\mathbf{v}$
$$\mathbf{\mu}_{2})\equiv I\{\mu_{1}=\mu_{2}\}$$
$$-{\mathcal{D}}\mathbf{v}\left(\mu\right)$$

This relation is useful for computing the integral of the product of two generalized normals:

for σ1+σ2 >0:X
∫ T(x,µ1,σ1) · T(x,µ2,σ2) dx = T(µ1, µ2, σ1 σ
2
$$+\,\sigma_{2}^{2}\,\,\rangle$$
$$\nabla_{2}>\!\!0\!:$$
+ ) (3)
And, for consistency, we define

$$\int_{x}{\mathcal{N}}(x,\mu_{1})\;{\mathcal{N}}(x)$$
$${\mathfrak{s}}_{2}=0\colon$$

for σ1 = σ2 = 0: X
∫ T(x,µ1) T(x,µ2) dx = T(µ1,µ2) ≡ I{µ1=µ2}
where *I{predicate*} = 1 if *predicate* is true and zero otherwise. Virtually any reasonable univariate probability distribution or likelihood function can be accurately modeled by an appropriate mixture of generalized normals. In particular, p.d.f.'s over symbolic variables are mixtures of impulses.

Without loss of generality, symbols may be arbitrarily mapped to specific numbers and represented over numeric axes. Integrals over discrete domains become sums.

Example 4: Let us approximate the p.d.f. p(x) of a mixed continuous and symbolic valued random variable x by a mixture of generalized normals. Assume that x takes with probability 0.4 the exact value 10 (with a special meaning), and with probability 0.6 a random value continuously distributed following the triangular shape shown in Fig. 3. The density p(x) can be accurately approximated (see Section 4) using 4 generalized normals:
p(x) ≅ .40T(x,10) + .21T(x,.04,.23) + .28T(x,.45,.28) + .11T(x,.99,.21)