
## 2.3 Inference Using Mixtures Of Conjugate Densities

The computation of p(z|S) may be hard, unless p(z) and p(S|z) belong to special (conjugate) families (Berger 1985, Bernardo & Smith 1994). In this case the posterior density can be analytically obtained from the parameters of the prior and the likelihood, avoiding numeric integration. The prior, the likelihood and the posterior are in the same mathematical family. The "belief structure" is closed under the inference process.

Example 5: In the univariate case, assume that z is known to be normally distributed around r with dispersion σr, i.e. p(z) = T(*z, r*, σr). Assume also that our measurement device has Gaussian noise, so the observed values are distributed according to *p(s|z*) = T(s, z, σs). Therefore, if we observe a certain value so, from the property of the product of generalized normals in eq.

(2), the posterior knowledge on z becomes another normal T(z, µ, ε). The new expected location of z can be expressed as a weighted average of r and so: η = γ so + (1-γ)r and the uncertainty is reduced to ε 2= γ2 σS
. The coefficient γ = 2 σr
/ (2 σr
+2 σS
) quantifies the relative importance of the experiment with respect to the prior.

This computational advantage can be extended to the general case by using mixtures of conjugate families (Dalal & Hall 1983) to approximate the desired joint probability distribution and the likelihood function.

Example 6: If the domain and the likelihood are modeled respectively by

$$p(z)\equiv\sum_{i}\ P_{i}\ {\mathcal{N}}(z,\,\mu_{i}\,,\sigma_{i}\,)\qquad p(s_{o}|z)\equiv\sum_{r}\ \pi_{r}\ {\mathcal{N}}(z,\,\eta_{r}\,,\,\varepsilon_{r}\,)$$

(where πr
, ηr and εr depend explicitly on the observed so), then the posterior can be also written as the following mixture:

$$p(z|s_{\mathrm{o}})\equiv\sum_{i,r}\,\theta_{i,r}\,{\mathcal{N}}(z,\mathbf{v}_{i,r},{\hat{\lambda}}_{i,r}\,)$$

From properties (2) and (3), the parameters νi,r and λi,r and the weights θi,r are given by:

$$\begin{array}{c c}{{\mathrm{V}_{i,\,r}=\frac{\sigma_{i}^{2}\eta_{r}+\varepsilon_{r}^{2}\mu_{i}}{\sigma_{i}^{2}+\varepsilon_{r}^{2}}}}&{{\quad\lambda_{i,r}=\frac{\sigma_{i}\ \varepsilon_{r}}{\sqrt{\sigma_{i}^{2}+\varepsilon_{r}^{2}}}}}\\ {{}}&{{}}\\ {{\theta_{i,r}=\frac{P_{i}\pi_{r}\ \mathcal{N}(\mu_{i}\,,\eta_{r}\,,\sqrt{\sigma_{i}^{2}+\varepsilon_{r}^{2}}\,)}{\sum_{k,l}P_{k}\pi_{l}\ \mathcal{N}(\mu_{k}\,,\eta_{l}\,,\sqrt{\sigma_{k}^{2}+\varepsilon_{l}^{2}}\,)}}\end{array}$$  then

$$(4)$$

## 2.4 The Role Of Factorization

Given a multivariate observation z partitioned into two subvectors, z = (x, y), assume that we are interested in inferring the value of the unknown attributes y from the observed attributes x. Note that if x and y are statistically independent, the joint density is factorizable: p(z) = p(x, y) = p(x)
p(y) and, therefore, the posterior p(y|x) equals the prior marginal p(y). The observed x carries no predictive information about y and the optimum estimators do no depend on x. For instance, y (x) MSE = E{y|x} = E{y} and y (x) ( y) EP a y = *rgmax* p . This is the simplest estimation task. No runtime computations are required for the optimum solution, which may be precalculated.