Let us call the agent's output symbols *motor symbols* and the agent's input symbols *sensor symbols*. We will call the sets of symbols the motor alphabet and the sensor alphabet, denoted M and S respectively. We will assume that the alphabets are fixed properties of our agent's embodiment; we will not consider models with different alphabets.

Let m = |M| and s = |S|. Then a model with n states may be completely specified by m different n × n transition matrices and one s × n output matrix.

For each x ∈ M, let us call the state transition matrix T
x. Note that the superscript here is not an exponent. We may call the output probability matrix A.

Since we will be speaking of two ontologies, O0 and O1, we will use subscripts to indicate which ontology we are taking these matrices from; for instance, T
x 0 is the state transition matrix for action x in the O0 ontology.

## 5. Maps Between Ontologies

Our basic approach to translating our utility function from O0 to O1 will be to construct a function from O1 to O0 and compose our utility function with this function. If

## (1) U : O0 → R

is a utility function defined on O0, and φ : O1 → O0, then U ◦ φ is a utility function defined on O1.

The function φ we will seek to define will be a *stochastic function*; its output will not be a single state within O0, but a probability distribution over states. Thus if O0 has n0 states while O1 has n1 states, φ will be most naturally expressed as an n0 × n1 matrix.

Let us consider some desiderata for φ:
1. φ should be determined by the *structure* of the models O0 and O1; the way in which the states are labeled is irrelevant.

2. If O0 and O1 are isomorphic to each other, then φ should be an isomorphism. This may seem irrelevant, for if O1 is isomorphic to O0, then there is no need to change models at all. Nevertheless, few would object to 2 on grounds other than irrelevance, and 2 may be seen as a special case of a more general statement:
3. If O0 and O1 are *nearly* isomorphic to each other, then φ should nearly be an isomorphism.

This criterion is certainly relevant; since O0 and O1 are both models of the same reality, they can be expected to be similar to that reality, and thus similar to each other.

In accordance with these desiderata, we will try to construct a function that is as much like an isomorphism as possible. To accomplish this, we will define in quantitative terms what we mean by "like an isomorphism." First, we observe that isomorphisms are invertible functions; thus, we will define a second function, which we fancifully call φ
−1: O0 → O1, even though it may not be a true inverse of φ, and we will optimize both φ and φ
−1to be "like isomorphisms".

Our criterion is a combination of the computer science notion of *bisimulation* with the information-theoretic idea of *Kullback-Leibler divergence*.

Bisimulation means that either model may be used to simulate the other, using φ and φ
−1to translate states between models. Thus, for any action x, we would