# Typical Models: Minimizing False Beliefs

Eliezer L. Lozinskii School of Computer Science and Engineering The Hebrew University, Jerusalem 91904, Israel email: lozinski@cs.huji.ac.il

## Abstract

A knowledge system S **describing a part of real world does in general**
not contain complete information. Reasoning with incomplete information is prone to errors since any belief derived from S **may be false in the**
present state of the world. A false belief may suggest wrong decisions and lead to harmful actions. So an important goal is to make false beliefs as unlikely as possible. This work introduces the notions of typical atoms and typical models**, and shows that reasoning with typical models minimizes**
the expected number of false beliefs over all ways of using incomplete information. Various properties of typical models are studied, in particular, correctness and stability of beliefs suggested by typical models, and their connection to oblivious reasoning.

Keywords: Incomplete information, reasoning errors, false beliefs, **typical**
models, evidence, oblivious reasoning, counting models.

## 1 Introduction

Let us consider a knowledge system S **describing a part of real world. The** knowledge contained in the system consists of data describing properties of various objects of the world, their mutual relationship, laws governing their behavior and evolution. For example, consider a system S **of medical knowledge** about the "world" of a hospital. S **contains description of diseases (their causes,** development, consequences, examination, symptoms, treatment, prevention),
information about various medicament (their composition, **therapeutic activity,** dosage, directions for use, interactions, side effects), description of the hospital
(its structure, management, location), personal data of the hospital patients (their medical history, test results), general rules of medicine, etc. An important decision that has to be made by a physician for his or her patient is determining the right diagnosis and the best treatment. The physician may wish to consult the vast amount of knowledge collected in the system. Will the system help the physician to make a right decision? This depends to a large extent on the way the knowledge is used for deriving conclusions.

Let us define important features of S **and their correspondence to the world**
it describes.

S is presented in a first order language. S **is consistent having a** set MOD(S) of models. Each model of S **is a set of ground atomic**