
## 4.4 Stable Beliefs

People are in constant quest for knowledge. The available knowledge about the real world is being expanded and deepened. If new knowledge is added to S, the set of models of S changes, and so the set of possible worlds W **changes as** well. Indeed, the new knowledge changes the image of the reality portrayed by S **for its users. The corresponding changes take place in sets of beliefs derived** from S by its users. Some beliefs regarding formulas incomplete in S **become** more certain, but others turn out to be false.

This phenomenon makes reasoning with incomplete information nonmonotonic: while S **grows, the set of belies and conclusions derived from**
S **may shrink. The possibility that some beliefs may become false is rather**
embarrassing and harmful. If a reasoner uses the semantics of typical models, this minimizes the expected number of beliefs that may be false in the present state of the world. Yet the reasoner would be interested to know more: Which, if any, of his or her beliefs are stable **in the sense that they remain credible** under some additions to the system. The set of stable beliefs **would possess a** property of relative monotonicity **with respect to these additions.**
The kernel property provides the following nice quality of stability of beliefs concerning kernel atoms.

Theorem 4.5 For all S, all ˆa ∈ tk(S), and any formula φ **that is consistent**
with S and does not contain a in its base, ˆa **is a typical kernel atom of**
S
′ = S ∪ {φ}. So addition of φ to S **does not require changing the belief in** ˆa derived from S **due to the semantics of typical models.**
Proof. Since the value of φ **does not depend on an assignment to**
ˆa ∈ tk(S), if φ cancels a model m of S containing ¬ˆa **then it cancels the**
a-neighbor of m containing ˆa, so still MOD(S
′ ∪ {¬ˆa}) = MN(S
′ **∪ {¬**ˆa}.

Hence, ˆa **retains its kernel property in** S
′. So beliefs in ˆa derived from S and S
′ **are identical.** ✷
Corollary 4.2 Let tk(S) = {aˆ1, . . . , aˆk}, and Base(φ) **denote the base of a**
formula φ. Then tk(S) **is monotonic with respect to a set of all formulas** φ such that Base(φ) ∩ {a1**, . . . , a**k} = ∅. ✷
Example 4.1 S = {p ∨ ¬q ∨ r, s ∨ v, ¬q ∨ r ∨ ¬s, ¬u ∨ ¬s, ¬p ∨ q ∨ ¬v, s ∨ ¬v, ¬q ∨ r ∨ ¬u, ¬p ∨ u ∨ **v, q** ∨ v}.

Table 1 presents data describing S: MOD(S) = {m1, m2, m3, m4, m5};
m3 = {¬p, q, r, s,¬u, v} is the most typical model of S **containing its**
typical kernel tk(S) = {¬p, r, s, ¬u, v} (compare |MOD(S ∪ {¬aˆ})| **with**
|MN(S ∪ {¬aˆ})| for ˆa ∈ {¬p, q, r, s,¬**u, v**}).

To illustrate stability of kernel atoms (Theorem 4.5) let us augment S **with**
φ = {¬p ∨ ¬q ∨ ¬r}**. Four bottom rows of Table 1 describe** S
′ = S ∪ {φ}.

MOD(S
′) = {m1, m2, m3, m4} since φ cancels m5. Although φ **contains kernel**
atom ¬p and even negation of kernel atom r, all kernel atoms of S **remain such**
in S
′: tk(S
′) = tk(S**). So in certain cases the stability of kernel atoms extends**
beyond the limits determined by Theorem 4.5. ✷