
## Appendix A. Approximation Of Evidence

Reasoning with typical models involves counting models. This is a \#P-complete problem (Valiant, 1979) presenting a highly complex computational task that for large logic systems is beyond the power of existing computers. One of practical ways to relax this difficulty is using approximation.

## A1. Credible Subsets

Given a system S and a query F**, should it be possible to find a subset of** S informative enough to provide a correct answer to F **with a high probability** and small enough to fit into the range of the available computing resources, the answer to F **could be produced efficiently. This approach has been studied** in Lozinskii (1997).

Definition 8.1 Let L
(1) denote a subset of S **consisting of all clauses of** S
containing a literal L or ¬L**. Call** L
(1) the first surrounding of L. For i > 1 let L
(i) denote the i-th surrounding of L, that is a set of all clauses of S **which**
either belong to L
(i−1) **or share a common variable with a clause of** L
(i−1). ✷
An i-th surrounding of L **provides an evidence** E(L
(i), L) of L **that can be**
considered as an approximation of E(S, L) with the **approximation error** ǫ
(i)
such that ǫ
(i) = E(L
(i), L) − E(S, L). A belief in L **suggested by** E(L
(i), L**) is**
credible if it is the same as that provided by E(S, L**). As reported in Lozinskii**
(1997), while i **increases, the value of** |ǫ
(i)| **decreases, and the probability that**
a belief suggested by E(L
(i), L**) is credible approaches 1. For most instances**
tested in Lozinskii (1997) the first surrounding provided credible beliefs with a high probability, while the corresponding run time was about 106**times shorter**
than that required for processing of the full S**. The credibility of approximation**
increases with the second and further surroundings along with a decrease of the run time gain.

## A2. Comparing Bounds

Algorithm 6.1 can be used for computing upper and lower bounds of the size of sets of models.

If a path P
(k) = {l1, . . . , lk} falsifies S but {l1, . . . , lk−1} **does not, call** P
(k)
a falsifying path. Any full assignment containing a falsifying path is a nonmodel of S**. Any falsifying path** P
(k)contributes 2n−k **non-models to the set**
of non-models of S containing a literal l **for every literal** l ∈ P
(k)**, and 2**n−k−1 non-models to the set of non-models of S **containing** l
′**for every literal** l
′**such**
that l
′ 6∈ P
(k) and ¬l
′ 6∈ P
(k).

Consider a run of Algorithm 6.1 starting at time τs **and finishing at** τf .

In the course of its run the algorithm discovers more and more **satisfying and**
falsifying paths, and accumulates models and non-models. Let Mt(l), Nt(l)
denote the number of models and non-models containing a literal l **counted**
between time τs and t. Since Mt(l) and Nt(l**) are non-decreasing functions of**