in the sense that it stands a good chance of being true in the reality. So a system of automated reasoning must be able to answer the following query:
Given a formula F and a system S **describing faithfully a world,**
what is a most credible belief regarding the truth of F **in the present** state of the world?

In order to answer various multiple queries consistently a reasoner has to choose one particular model µ of S (a preferred model**) and then believe that** F
is true in the reality iff µ |= F. If S |= F or S |= ¬F then the choice of µ **does**
not matter; however, if F is incomplete in S then F **is true in some models,**
but false in the others. Which is the correct value of F **in the present state of** the world? With any choice of µ **there is a non-zero probability that the belief**
in F implied by µ **is false in the present state of the world. So reasoning with**
incomplete information is **prone to errors**.

The way of choosing the preferred model provides a semantics for the process of reasoning. Whatever this way is, errors are inevitable since the preferred model may not fully conform to the present state of the **world. The**
smaller the expected number (or the severity) of errors, the **more reliable**
the semantics. Numerous approaches to reasoning with incomplete information have been developed including Nonmonotonic Logics **(Antoniou, 1997;**
Brewka et al., 2007; Shoham, 1987) and methods based on Semantics of Minimal Models **(Bidoit et al., 1986; Gelfond et al., 1988; McCarthy, 1980; Minker,**
1982; Van Gelder et al., 1991). Neither of the previous work considered minimization of the risk that beliefs sanctioned by the proposed **semantics are false**
in the real world. A false belief may suggest wrong decisions **and lead to harmful actions. As reasoning errors caused by incompleteness of information are**
inevitable, minimization of the number and likelihood of false beliefs becomes practically important a goal.

The following sections introduce the semantics of typical models **and show**
that it minimizes the expected number of erroneous beliefs over all ways of reasoning with incomplete information.

## 2 Evidence

At any moment the world is in exactly one of its possible states, so in exactly one of possible worlds represented by the corresponding model of S**. Let** p(w) denote the probability that at a randomly chosen moment the world is in a state belonging to a possible world w ∈ W represented by a model µ of S**. Then to**
every µ ∈ MOD(S) representing the corresponding w ∈ W **one may assign a**
probability p(µ) = p(w) such that Pµ∈MOD(S)
p(µ) = Pw∈W p(w**) = 1. So the**
probability p(F) that a formula F **is true in the present state of the world is**

$$p(F)=\sum_{\mu\in M O D(S\cup\{F\})}p(\mu)$$

where MOD(S ∪ {F}) = {µ|µ ∈ MOD(S) ∧ µ |= F} **is the set of models of** S
implying F.

$$(1)$$
