Consider a reasoner R **that forms beliefs in order to answer a series of queries**
F1, . . . , Fk. Denote by R(Fi) his belief regarding the truth of Fi**. If the reasoner**
computes R(Fi) as his answer to Fi **without taking into account the previous** beliefs R(Fj ) (1 ≤ j < i) preceding R(Fi**), let us call this way of reasoning**
oblivious. Then if it turns out that there is no model of S **in which all of**
R(F1), . . . , R(Fi) are true, then the beliefs of R are inconsistent with S **which**
is unacceptable.

Oblivious reasoning with incomplete information may lead to inconsistency.

Indeed, let MR(Fi) denote a set of all models of S in which R(Fi**) is true. Then**
the set of beliefs {R(F1), . . . , R(Fk)} is consistent with S **(and so, holds in some**
state of W**) iff**

$$\bigcap_{i=1}^{n}M_{R(F_{i})}\neq\varnothing.$$
k

MR(Fi ) 6= ∅. (3)
For all queries F incomplete in S, MR(F)is a proper subset of MOD(S**), so**
the size of their intersection (3) is a monotone decreasing function of k **such**
that for a large k condition (3) may not hold 1**. This does not happen if**
the reasoning is non-oblivious such that in derivation of R(Fi**) all previously**
produced beliefs are taken into consideration. One way of doing so is to derive R(Fi) from S ∪ {R(F1), . . . , R(Fi−1)}**. In this case, however, the value of each**
belief depends on the order of queries in their sequence.

Example 3.1 S = {a ∨ b, b ∨ c, c ∨ a,¬a ∨ ¬b ∨ ¬c};
MOD(S) = {{a, b,¬c}, {a,¬b, c}, {¬**a, b, c**}}.

Queries: F1 = a, F2 = b, F3 = c; k = 3; E(S, a) = E(S, b) = E(S, c**) = 2**/3.

Obliviously: R(a) = R(b) = R(c) =′true′ **which is inconsistent with** S.

Non-obliviously: let S0 = S, Si = Si−1 ∪ {R(Fi)} for 1 ≤ i ≤ k**. Then**
E(S0, a) = 2/3; R(a) =′true′; S1 = {a, b ∨ c,¬b ∨ ¬c};
E(S1, b) = 1/2; R(b) =′true′; S2 = {**a, b,**¬c};
E(S2, c) = 0; R(c) =′ f alse′**. All these beliefs hold in the first model of** S. ✷
Non-oblivious reasoning requires keeping track of many previously produced beliefs, so in general it is more time-consuming than its oblivious counterpart. Thus it would be helpful to determine sets of queries that can **be answered**
obliviously in any order without any risk of inconsistency. **A trivial example is** a set of all formulas F such that S |= F**. Subsection 4.3 presents less obvious** sets allowing oblivious reasoning.

## 4 Semantics Of Typical Models

This section introduces the basic notions of typical atoms and typical models, and studies stability of the corresponding beliefs.

1For instance, in Example 3.1 expression (3) holds for k = 2, but not for k = 3.