Using this technique, all trajectories are so transformed that they encode valid paths.

This improved version of the Ariadne's clew algorithm no longer cares about obstacles.  From the point of view of a search in the trajectory space, it is as if the obstacles have simply vanished. This method is especially efficient for narrow corridors in the configuration space.

Without bouncing, the mapping of a corridor in the configuration space to the trajectory space is a set of very few points. With bouncing, every single trajectory going through a part of the corridor is "folded" into the corridor (see Figure 7). The resultant mapping of the corridor in the trajectory space is consequently a much larger set of points, and therefore it is much easier to find a member of this set. This empirical improvement has a major practical impact because it makes the proposed algorithm faster (fifteen times) in the problem considered below.

## 3.5 The Algorithm

We can now give a final version of the Ariadne's clew algorithm. It has three inputs: ˆ q o
(the initial position), ˆ q (the goal position), and ρ (the maximum allowed distance for a path to the -obstacles ). It returns a legal path or terminates if no path exists at the given resolution.

ALGORITH M_ARI ADN E( go, go, p )
begin i := 1; λ 1 := qo;
/* Initialize the set of landmarks with the initial position Λ :=  λ 1  ; ε 1 = +
do while (ε; p);
/* run SEARCH : look for the goal with a local method if (minifiet d(q), q(l)) == 0)
return; /* A path has been found !

else
/* run EXPLORE : place a new landmark i := : + 1 :
Xi := q : suplEIRt d(Ai-1, q(l));
A; := A; -1 xxx ε ; := d(Λ i − 1, λ i );
endif enddo A = A,:
E = E,
return(ε); /* No path !

![0_image_0.png](0_image_0.png)

end