

![0_image_0.png](0_image_0.png)

## 4.1.2 Principle Of The Parallel Genetic Algorithm (Pga)

There are many parallel versions of genetic algorithms: the standard parallel version (Robertson, 1987), the decomposition version (Tanese, 1987) and the massively parallel version (Talbi, 1993). We chose this last method. The main idea is to allocate one element of the population for each processor so that steps 1, 3, and 4 can be executed in parallel. Furthermore, the selection step (step 2) is carried out locally, in that each individual may mate only with the individuals placed on processors physically connected to it. This ensures that the communication overhead does not increase as the number of processors increases. This is the reason why PGA shows linear speed-up.

The parallel genetic algorithm iterates the following four steps until a solution is found.

1. Evaluation : Evaluate in parallel all the individuals.

2. Selection : Select in parallel , among the neighbors, the mate with the best evaluation.

3. Reproduction : Reproduce in parallel with the chosen mate.

4. Replacement: Replace in parallel the parents by the offspring.

On the Meganode, we implemented the PGA on a torus of processors where each individual has four neighbors (see Figure 10)

## 4.2  Parallel Evaluation Of The Cost Function

The evaluation functions used in SEARCH and EXPLORE are very similar: they both compute the final position of the arm given a Manhattan path of a fixed order. In our implementation, based on experience, we chose to use Manhattan paths of order 2. Order 2 appeared to be a good compromise between the number of landmarks needed (increases as order decreases) and the computing time necessary for the optimization functions (increases as order increases).  Since our robot has six DOF, the argument of the cost function in SEARCH is a vector in R 12 : ( Δ + Δ + …, Δ + …, Δ 2 , …, Δ 2 ) and the argument of the cost function used for EXPLORE is a vector in IN x IR 12 : (i, A+, A+, . . . , A+, . . , A+, . . , A 2 ) where i codes the landmark used as a starting point for the path. In both cases the functions are defined only on a bounded subset of IR 12 and IN × R 12 , whose limits are fixed by the mechanical stops of the robot and the maximum number of landmarks. A discretization step is chosen for these two subsets by defining the resolution at which each elementary motion is discretized.