1. The fundamental reason is, once again, the NP-completeness of the path planning problem. As deceptive cases may always be designed, the only performance results one may reasonably present are always specific.

2. The three practical reasons are:
(a)  Obviously, the first requirement for such a comparison is that different algorithms run on the same machines with the same available memory.  This may seem simple but it is a main difficulty in our case because our algorithm has been designed to run on rather specific kinds of machines, namely, massively parallel ones. It could also be implemented on non-parallel machines, but then it may lose part of its interest. A fair comparison would be to compare the algorithms on both types of machines. This would imply programming other algorithms in parallel, which is very difficult in practice.

(b) Many known path planning algorithms first compute the configuration space
(or an approximation of it) off-line, and then efficiently solve the path planning problem on-line. As we saw, in order to deal with a dynamic environment, the Ariadne's clew algorithm adopts a completely different approach.

(c) For practical reasons, many test problems are toy problems (2 D, few obstacles, few faces, simulated robots) and the performance results using these kinds of problems are very difficult to generalize to realistic industrial problems (3D, tens of obstacles, hundreds of faces, real robots).

Considering all these reasons, we tested our algorithm by implementing arealistic robotic application to the very end. To achieve this goal, we assembled a complex experimental ssetup including six different machines (1 MEGANODE, 2 68030, 2 SUN 4, and 1 SILICON
GRAPHICS), two mechanical arms, and running seven different cooperative programs (2 KALI, 1 ACT, 2 VXWORKS, 1 PARX, and 1 Ariadne's clew algorithm).

Our challenge was to be able to solve the path planning problem fast enough to drive a real six DOF arm in a dynamic environment. The Ariadne's clew algorithm indeed achieved this goal in our experiments where the environment is composed of five fixed obstacles and a six DOF arm moving independently.

We are not aware of any other methods capable of such performance. To the best of our knowledge, currently implemented planners would take a number of seconds (ten) to place a set of landmarks on a 2D example for a robot with five DOF (Kavraki et al., 1996). Despite the fact that finding a general purpose planning technique for real industrial application is a very difficult problem, we believe that the Ariadne's clew algorithm provides an effective approach to such problems.

The number of range computations for a Manhattan motion of order 1 is C k 2 +k where n is the number of faces, k the number of DOF, and C a constant factor, depending on the number of parts used to model the robot.  Obviously, such a number of faces may be a severe difficulty for the implementation of the Ariadne's clew algorithm described so far.

To speed up the computation we use a number of geometric filters that reduce the number of pairs of entities to be analyzed.

However, it was possible to follow two research tracks in combination. First, we could use collision checking methods that allow access to the pairs in collision in a logarithmic