
## 2. The Path Planning Problem

Many versions of the path planning problem exist. An exhaustive classification of these problems and of the methods developed to solve them can be found in a survey by Hwang and Ahuja (1992). We choose to illustrate our discussion with a particular case. A robot arm is placed among a set of obstacles. Given an initial and a final position of the robot arm, the problem is to find a set of motions that will lead the robot to move between the two positions without colliding with the obstacles.

To drive the robot amidst the obstacles, early methods (Brooks, 1983) directly used the 3D CAD models of the robot and of the obstacles to find a solution, i.e., they considered the
"operational 3d space". In this space, the path planning problem consists of finding the movements of a complex 3D structure (the robot) in a cluttered 3D space.

A major advance was to express the problem in another space known as the configuration space, denoted by   (Lozano-Pérez, 1987). In this space, the position (or configuration)
of a robot is completely determined by a single point having n independent parameters as coordinates.  The positions that are not physically legal (because of a collision) are represented by particular regions of  , and are called  -obstacles. In the configuration space, the path planning problem consists of finding a continuous curve (representing a path for a single geometrical point) that (i) connects the points representing the initial and the final configuration of the robot, and (ii) does not intersect any -obstacles.  This method trades a simplification of the path planning problem (it searches a path for a single point)
against a higher-dimensional search space (the dimension of   is the number DOF of the robot) and against more complex shapes of obstacles (very simple physical obstacles may result in very complex -obstacles).

For example, let us consider the planar arm of Figure 1. Its position among the obstacles is totally known once the values of the angles between its links ( go, q 1 ) are known. Thus, for each pair ( q 1 ), it is possible to decide whether the robot collides with the surrounding obstacles. This is what we did in Figure 2 to represent the mapping between the physical obstacles in the operational space and the  -obstacles. Now, by moving a point along the curve joining ˆ q and ˆ q f one will also define a collision-free motion for the planar arm between the corresponding positions P( ˆ ααα ) and P( ˆ ααα ) in the operational space.  This curve is one solution to this particular path planning problem.

A recent trend in the field is to consider the "trajectory space" (Ferbach, 1996) where a whole path is represented by a single point. The coordinates of this point are the values of the parameters defining the successive movements of the robot. For instance, the list of successive commands sent to the robot controller indeed encode an entire path of the robot. In this space, the path planning problem is reduced to the search for a single point. Once again, we trade a simplification of the path planning problem (searching for a point) against a higher dimension of the search space (the dimension of the trajectory space is the number of parameters needed to specify completely a whole path). For example, in Figure 2, the path between ˆ α b and ˆ α can be represented by a point in a seven-dimensional space simply by considering the length of its seven segments.