fail to reach a goal, new subgoals are generated until the problem is easy enough to be solved. In their approach, first a local planner is used to reach the final position: should the local planner fail, the configuration space is divided into two subspaces, one containing the goal and the other a new sub-goal. The problem is therefore divided into two sub-problems:
(i) going from the initial position to the subgoal, and (ii) going from the subgoal to the final position. SANDROS has been shown to be particularly well adapted to find paths for manipulators. It has been implemented and tested for planning paths for Puma and Adept robots.

## 2.4  Path Planning In The Trajectory Space

The previous methods were essentially based on the configuration space: the retraction, the decomposition, or the optimization is made in this space. An alternative is to consider the
"trajectory space". For example, in his method VDP, Ferbach (1996) starts by considering the straight line segment joining the initial and the final configuration in . This path is progressively modified in such a manner that the forbidden regions it crosses are reduced. At each iteration, a sub-manifold of containing the current path is randomly generated.

It is then discretized and explored using a dynamic programming method that uses the length across the forbidden region as the cost function in order to minimize. The search results in a new trajectory whose intersection with the forbidden regions is smaller than the original trajectory. The process is repeated until an admissible trajectory is found. As in the previous sections, it is also possible to design simple deceptive environments that will make this kind of algorithm slower than a pure random approach.

The work of Lin, Xiao, and Michalewicz (1994) is similar to our approach. As in an early version of our algorithm (Ahuactzin, Mazer, Bessière, & Talbi, 1992), genetic algorithms are used to carry out optimization in the trajectory space. Trajectories are parameterized using the coordinates of intermediary via points. An evolutionary algorithm is used to optimize a cost function based on the length of the trajectory and the forbidden region crossed. The standard operators of the genetic algorithms have been modified and later extended to produce a large variety of paths (Xiao, Michalewicz, & Zhang, 1996). The number of intermediary via-points is fixed and chosen using an heuristic. Given this number, nothing prevents to design a deceptive problem which solution will require more intermediary points, leading the algorithm to fail while one solution exists.

## 3. Principle Of The Ariadne'S Clew Algorithm

As we have seen in the previous section, the computation of the configuration space is a very time-consuming task. The main idea behind the Ariadne's clew algorithm is to avoid this computation. In order to do this, the algorithm searches directly for a feasible path in the trajectory space. The configuration space is never explicitly computed.

As will be shown, in the trajectory space, path planning may be seen as an optimization problem and solved as such by an algorithm called SEARCH. It is possible to build an approximation of free space by another algorithm called EXPLORE that is also posed as an optimization problem.  The Ariadne's clew algorithm is the result of the interleaved execution of SEARCH and EXPLORE.