# Computational Aspects Of Reordering Plans

## Christer  Bäckström

Department of Computer and Information Science Linköpings universitet, S-581 83 Linköping, Sweden

## Abstract

CBA ©IDA.LIU. SE
This article studies the problem of modifying the action ordering of a plan in order to optimise the plan according to various criteria. One of these criteria is to make a plan less constrained and the other is to minimize its parallel execution time. Three candidate definitions are proposed for the first of these criteria, constituting a sequence of increasing optimality guarantees. Two of these are based on deordering plans, which means that ordering relations may only be removed, not added, while the third one uses reordering, where arbitrary modifications to the ordering are allowed. It is shown that only the weakest one of the three criteria is tractable to achieve, the other two being NP-hard and even difficult to approximate. Similarly, optimising the parallel execution time of a plan is studied both for deordering and reordering of plans. In the general case, both of these computations are NP-hard. However, it is shown that optimal deorderings can be computed in polynomial time for a class of planning languages based on the notions of producers, consumers and threats, which includes most of the commonly used planning languages.  Computing optimal reorderings can potentially lead to even faster parallel executions, but this problem remains NP-hard and difficult to approximate even under quite severe restrictions.

## 1. Intro Duction

In many applications where plans, made by man or by computer, are executed, it is important to find plans that are optimal with respect to some cost measure, typically execution time. Examples of such applications are manufacturing and error-recovery for industrial processes, production planning, logistics and robotics. Many different kinds of computations can be made to improve the cost of a plan   only a few of which have been extensively studied in the literature. The most well-known and frequently used of these is scheduling. A plan tells which actions (or tasks) to do and in which order to do them, while a schedule assigns exact release times to these actions. The schedule must obey the action order prescribed by the plan and must often also satisfy further metric constraints such as deadlines and earliest release times for certain actions. A schedule is feasible if it satisfies all such metric constraints. It is usually interesting to find a schedule that is optimal in some respect, eg the feasible schedule having the shortest total execution time, or the schedule missing the deadlines for as few actions as possible.

In principle, planning and scheduling follow in sequence such that scheduling can be viewed as a post-processing step to planning  where planning is concerned with causal relations and qualitative temporal relations between actions, while scheduling is concerned with metric constraints on actions. In some planning systems, eg O-Plan (Currie & Tate, 1991) and SIPE (Wilkins, 1988), both planning and scheduling are integrated into one single system.  Similarly, temporal planners, eg DEVISER (Vere, 1983) and IXTET (Ghallab
& Laruelle, 1994), can often reason also about metric constraints. This does not make it