irrelevant to study planning and seduling as separate problems, though, as can be seen from the vast literature on both topics. The two problems are of quite different character and studying them separately gives important insight also into such integrated systems as was just discussed. For instance, Drabble 1 says that it is often very difficult to see when O- PLAN plans and when it schedules; it is easy to see that O- PLAN works, but it is difficult to see why.

A further complication in understanding the difference between planning and scheduling, both for integrated systems and for systems with separated planning and scheduling, is that certain types of computations fall into a grey zone between planning and scheduling. Planners are good at reasoning about effects of actions and causal relationships between actions, but are usually very poor at reasoning about time and temporal relationships between actions. Schedulers, on the other hand, are primarily designed to reason about time and resource conflicts, but have no capabilities for reasoning about causal dependencies between actions. The problems in the grey zone require reasoning of both kinds, so neither planners nor schedulers can handle these problems properly.  If these problems are not solved, then the scheduler does not get sufficient information from the planner to do the best of the situation the planner and the seduler may fail in their cooperation to find a plan with a feasible schedule, even when such a plan exists.

This article focusses on one of these grey-zone problems, namely the problem of optimising the action order of a plan to allow for better schedules. Whenever two actions conflict with each other and cannot be allowed to execute in parallel, a planner must order these actions. However, it usually does not have enough information and reasoning capabilities to decide which of the two possible orders is the best one, so it makes an arbitrary choice.

One of the choices typically allows for a better schedule than the other one, so if the planner makes the wrong choice it may prevent the scheduler from finding a good, or even feasible, schedule. This situation arises also when plans are made by a human expert, since it is difficult to see which choice of ordering is the best one in a large and complex plan. Planning stems of today usually cannot do anything better than asking the planner for a new plan if the scheduler fails to find a feasible schedule. This is an expensive and unsatisfactory solution, especially if there is no feedback from the scheduler to help the planner making a more intelligent choice next time. Another solution which appears in the literature is to use a filter between the planner and scheduler which attempts to modify the plan order to put the scheduler in a better position. Such filters could remove certain over-commitments in the ordering, which will be referred to as deordering the plan, or even change the order between certain actions, which will be referred to as reordering the plan.

This article is intended to provide a first formal foundation for studying this type of problems. It defines a number of different optimality criteria for plan order modifications, both with respect to the degree of over-committment in the ordering and with respect to the parallel execution time, and it also provides computational results for computing such modifications. The article also analyses some filtering algorithms suggested in the literature for doing such order modifications.

The remainder of this article is structured as follows. Section 2 introduces the concepts and computations studied in this article by means of an example. Then Section 3 starts the