
## 7. Restricted Cases

Since the problems of computing minimum de-/reorderings are very difficult, and are even difficult to approximate, an alternative way of tackling them could be to study restricted cases.  One special case already considered is the restriction to definite plans only.  While the problem MMPR is still NP-complete under this restriction, it is an open question whether also MMPD is NP-complete. A positive result can be proven, though, to the effect that MMPD is polynomial for definite plans for a large class of planning languages, including most of the commonly used ones. This result will be proven by generalising an algorithm from the literature for deordering total-order plans.

Based on the (not necessarily true) argument that it is easier to generate a t.o. plan than a p.o. plan when using complex action representations, Regnier and Fade (1991a, 1991b) have presented an algorithm for converting a t.o. plan into a p.o. plan. The resulting plan has the property that all its unordered actions can be executed in parallel, that is, the plan is definite. The authors of the algorithm further claim that the algorithm finds all pairs of actions that can be executed in parallel and, hence, the plan can be post-processed to find an optimal parallel execution. They do not define what they mean by this criterion, however.

Incidentally, the algorithm proposed by Regnier and Fade is a special case of an algorithm earlier proposed for the same problem by Pednault (1986), who did not make any claims about optimality.  If removing from Regnier and Fade's algorithm all details relevant only for their particular implementation and planning language, the two algorithms coincide and they are thus presented here as one single algorithm, the PRF algorithm 4 (Figure 10). PRF is slightly modified from the original algorithms. First, it does not assume that the input plan is totally ordered, since it turns out to be sufficient that it is a definite partial-order plan. Second, PRF returns a parallel plan, rather than a p.o. plan a harmless modification since the only additional piece of information is the non-concurrency relation, which is already given as input, either explicitly or implicitly. Third, PRF returns the transitive closure of its ordering relation. This is by no means necessary, and is motivated, as usual, by conforming to the definitions of this article.

1  procedure PRF;
Input: A ppi I, a II-valid definite p.o. plan (    <) and a non-concurrency 2 relation \#
 Output: A Π-valid parallel plan 3 4  for all    E   s.t.

Y
do 5 if \#  then 6 Order 7  return (  <'+ \#);
Figure 10: The PRF algorithm Obviously, PRF computes a deordering of its input, and it is unclear whether it is possible to compute a minimal definite deordering in polynomial time. However, the algorithm