Procedure "instantiate", whi generates an instantiation of a cluster tree, is modified as follows:
procedure instantiate( in T : cluster tree; Ω : Euclidean space; B : real);
return : array of points indexed on the symbols of T ;
Let n be the number of nodes in T ;
α := 2 + 2n + Bn; Choose 61, 62 . . . 6n such that 6j < 6j+1/aj pick a point x E Ω;
G[T] := x; instantiate1(T, Ω, δ 1 . . δ n , G );
return the restriction of G to the symbols of T .

end instantiate.

instantiate1( in N : a node in a cluster tree; Ω : a Euclidean space; δ 1 . . . δ n : orders of magnitude; in out G : array of points indexed on the nodes of T )
if N is not a leaf then let C 1 . . . C p be the children of N ;
x 1 := G[N]; g := N label; pick points x . . x p such that for all i, j ∈ 1 . . p, if i ̸ = j then δ g ≤ dist( x i, x j ) < πδ g
/* This is possible since p ≤ n. */
for x = 1 . . p do G[C] := x, instantiate1( C i ,  Ω, δ 1  . . δ n ,  G )
end for endif end instantiate1 The analogue of lemma 2 holds for the revised algorithm:
Lemma 22: Any cluster tree T has an instantiation in Euclidean space R m of any dimensionality m.

We can now state theorem 3, which asserts the correctness of algorithm "solve constraints" in this new setting:
Theorem 3: Let S be a set of constraints over n variables of the form "dist(a, b) <
dist(c,d) / B", where B > n. The algorithm solve constraints(S) returns a cluster tree satisfying S if S is consistent over Euclidean space, and returns false if S is inconsistent.

The proofs of lemma 22 and theorem 3 are given in the appendix.

An examination of the proof of lemma 22 shows that this result does not depend on any relation between n and B . Therefore, if solve constraints( S ) returns a tree T , then S is consistent and T satisfies S regardless of the relation between n and B . However, it is possible for S to be consistent and solve constraints( S ) to return false if n ≥ B . On the other hand, one can see from the proof of theorem 3 (particularly lemma 23) that if B > n and solve constraints( S ) returns false then S is inconsistent in any metric space. However, there are metric spaces other than R m in which the cluster tree returned by solve constraints may have no instantiation.