solved efficiently. The logical foundations for dealing with infinitesimal quantities lie in the nn-standard model of the real line with infinitesimals, developed by Abraham Robinson (1965). (A more readable account is given by Keisler, 1976.) Reasoning with quantities of infinitely different scale is known as "order of magnitude" reasoning.

The reader may ask, "Since infinitesimals have no physical reality, what is the value of developing techniques for reasoning about them?" In none of the examples, after all, is the smaller quantity truly infinitesimal or the larger one truly infinite. In example 1 and 2, the ratio between successive sizes is somewhere between 10 and 100; in example 3, it is between 100 and a rather large number difficult to estimate; but one can always give some kind of upper bound. It is essentially certain, for instance, that the ratio between the times required for tasks (a) and (i) is less than 10100,000  Why not use the best real-valued estimate instead?

The first answer is that this is an idealization. Practically all physical reasoning and calculation rest on one idealization or another: the idealization in the situation calculus that time is discrete; the idealization that solid objects are rigid, employed in most mechanics programs; the idealization that such physical properties as density, temperature, and pressure are continuous rather than local averages over atoms, which underlies most uses of partial differential equations; the idealization involved in the use of the Dirac delta function; and so on.  Our idealization here that a very short distance is infinitesimally smaller than a long one simplifies reasoning and yields useful results as long as care is taken to stay within an appropriate range of application.

The second answer is that this is a technique of mathematical approximation, which we are using to turn an intractable problem into a tractable one. This would be analogous to linearizing a non-linear equation over a small neighborhood; or to approximating a sum by an integral.

There are circumstances where we can be sure that the approximation gives an answer that is guaranteed exactly correct; namely if the actual ratio implicit in the comparison
"D is much smaller than E" is larger than the number of points involved in the system of constraints. This will be proven in Section 7. There is also a broader, less well-defined, class of problems where the approximation, though not guaranteed correct, is more reliable than some of the other links in the reasoning. For instance, suppose that one were to consider an instance of example 3 involving a couple of hundred tasks, apply order-of-magnitude reasoning, and come up with an answer that can be determined to be wrong. It is possible that the error would be due to the order-of-magnitude reasoning. However, it seems safe to say that, in most cases, the error is more likely to be due to a mistake in estimating the comparative sizes.

## 3. Order-Of-Magnitude Spaces

An order-of-magnitude space, or om-space, is a space of geometric points. Any two points are separated by a distance. Two distances d and e are compared by the relation d « e, meaning "Distance d is infinitesimal compared to ε " or, more loosely, "Distance d is much smaller than e."
For example, let R* be the non-standard real line with infinitesimals. Let R*m be the corresponding m -dimensional space. Then we can let a point of the om-space be a point in