Thus, for example, in Figure 1, n3.label=3 and n3.symbols = { a, d }; n1.label = 5 and n1.symbols = { a, b, c, d, e, f, g}.

As we shall see, the nodes of the tree T represent the clusters of a set of points, and the labels represent the relative sizes of the diameters of the clusters.

Definition 4: A valuation over a set of symbols is a function mapping each symbol to a point in an om-space. If T is a cluster tree, a valuation over T is a valuation over T .symbols.

If N is any node in T and Γ is a valuation over T , we will write Γ( N ) as an abbreviation for F( N symbols).

We now define how a cluster tree T expresses the order of magnitude relations over a st of points P. Definition 5: Let T be a cluster tree and let Γ be a valuation over T . Let P = Γ( T ), the set of points in the image of T under Γ . We say that Γ = T (read Γ satisfies or instantiates T) if the following conditions hold:
i. For any internal node N of T , Γ( N ) is a cluster of P .

i. For any cluster C of P, there is a node N such that C = Γ( N ).

ii. For any nodes M and N , if M .label < N .label then odiam( Γ( M )) ≪ odiam( Γ( N )).

iv. If label( M ) = 0, then odiam( M ) = 0. (That is, all children of M are assigned the same value under Γ .)
The following algorithm generates an instantiation Γ given a cluster tree T :
procedure instantiate(in T : cluster tree; Ω : an om-space)
return : array of points indexed on the symbols of T
variable G [ N ] : array of points indexed on the nodes of T ;
Let k be the number of internal nodes in T ; Choose δ 0 = 0 ≪ δ 1 ≪ δ 2 ≪ . . ≪ δ k to be k + 1 different orders of magnitude;
/* Such values can be chosen by virtue of axiom A.7 */
pick a point x E Ω;
G[root of T] := x; instantiate1(T, S2, 61 . . . 6k, G);
return the restriction of G to the symbols of T .

end instantiate.

instantiate1( in N : a node in a cluster tree; Ω : an om-space; δ 1 . . δ k : orders of magnitude; in out G : array of points indexed on the nodes of T )
if N is not a leaf then let C 1 . . . C p be the children of N ;
x 1 := G[N];
q := N label; pick points x . . x p such that for all i, j E 1 . . p, if i ̸ = j then od( x i , x i ) = δ o ;
/* Such points can be chosen by virtue of axiom A.8 */