
## 2.4  Constructing The  Property Spaces And Synthesising The  Types

The objective of this stage is to construct the type structure of the domain by identifying domain objects with distinct property spaces. Objects can appearin more than one property space, giving us a basis for deriving a hierarchical type structure.

The first part of the process involves completing the seeded property spaces. The first task is to associate transition rules with the appropriate property space seeds. This can be easily done by picking an arbitrary property of the start or finish component of each rule and identifying the property space seed to which that property belongs. There can never be ambiguity because every property belongs to only one seed and uniting ensures that all of the properties referred to in a rule belong to the same seed. At this point the distinction between states and attributes becomes important. Any property space seed that has an attribute transition rule associated with it becomes an attribute space and is dealt with differently from property spaces in certain respects explained below.

The next step is to identify the domain objects associated with each property space and attribute space.

For each object referred to in the initial state we construct a type vector in which a bit is set if the corresponding space is inhabited by the object. An object can inhabit more than one space. Habitation is checked for by identifying all of the properties that hold, in the initial state, of the object being considered and allocating them as states, rather than as properties, to the appropriate state and attribute spaces. When every domain object has been considered a unique type identifier is associated with each of the different bit patterns.

The next task is to populate the property spaces with states. The following definitions are required to support the explanation of this process.

Definition 14 A world-state is a collection of propositions characterising the configuration of the objects in a given planning domain description.

Definition 15 Given a world-state, W, a property space, P = (Ps,TRs,Ts,Os), or an attribute space, P = (Ps,TRs,Os), and an object o   Os, the P-projection of St for o is the bag of properties, possessed by o in W , each of which belongs to Ps.

The collection of properties of an object, o, in the initial state can be divided into a set of bags of properties, each bag corresponding to the P-projection of the initial state for o, for some property or attribute space P. Each bag is added to the state set of the corresponding property space, or discarded if the corresponding space is an attribute space. We now need to extend the spaces by, for each property space, adding states that can be inferred as reachable by objects within that space along transitions within that space. This is done for ery state in the space, including states that are newly added during this process, until no further new states are reachable. The ordering of the properties within states is irrelevant, so two states are considered equal if they contain the same properties, regardless of ordering
(they are considered order-equivalent). Since, when we come to use this information in parts of the process of invariant generation, we will not require knowledge of any inclusion relations between pairs of states, it is convenient to mark these at this stage. The addition of reachable states is important for the inference of state invariants, and their use will be discussed in Section 2.7. The attribute spaces receive different treatment at this point. The