important difference to observe is that, since property spaces characterize the exchange of properties, objects in a property space must start off in the initial state as members of that property space. However, since attributes can be acquired without exchange, it is possible for objects that do not have particular attributes in the initial state to acquire those attributes later. This is only possible if the attribute space has an increasing attribute transition rule associated with it. We now, therefore, consider each attribute space to see whether further objects can be added by application of any corresponding increasing rule.

An object can be added to an attribute space if it potentiales all of the enablers of an increasing rule in that attribute space. An object potentiates an enabling property if it is a member of the state or attribute space to which that property belongs. Membership of all of these spaces indicates that the object could enter a state in which it satisfies all of the enabling properties, which would justify an application of the increasing rule. Any enabling property that is not associated with a state or attribute space is a static condition, sset the initial state can be checked to confirm that the property is true of the object being conside red.

A complication arises if any enabling property was itself used to seed an attribute space
(in which case it is itself an attribute), because it is then necessary to identify all of the objects in its attribute space and consider them for addition to the current attribute space.

Of course this could, in principle, initiate a loop in the process but we avoid this by marking attribute spaces as they are considered and ensuring, by iterating until convergence, that all of the attribute spaces in the loop are completely assigned. The correctness of this part of the procedure is discussed in Section 3.

When this is done the state and attribute spaces are complete and the types of the domain objects can be extracted. The completeness of this construction phase is discussed in Section 3.1.

## 2.5  A Worked Example

A fully worked example of all stages of the process will help to clarify what is involved.

Consider a simplified version of the Rocket domain in which there are two operator schemas:

| drive( X,Y,Z)   |                                            |               |
|-----------------|--------------------------------------------|---------------|
| Pre:            | at (X, Y),    fuelled (X),    location (Z) |               |
| Ad:             | at (X, Z).                                 | unfuelled (X) |
| Del:            | at (X, Y),    fuelled (X)                  |               |
| load(X,Y,Z)     |                                            |               |
| Pre:            | at(X,Y), at (Z,Y)                          |               |
| Ad:             | in(X,Z)                                    |               |
| Del:            | at(X,Y)                                    |               |

and an initial state containing four constants:  rocket, package, London and Paris, and the relations: at(rocket,Paris), fuelled(rocket) and at(package,London). It can be observed that this simplified Rocket domain has the rather odd feature that the load schema is not restricted to loading packages into rockets. This oddity will be highlighted by the analysis that is constructed, showing how the analysis performed by TIM can help in understanding
(and debugging) the behaviour of the domain. From the drive operator schema the following PRSs are constructed for variables X, Y and Z respectively: