for some positive integer k. If P holds of multiple objects in the initial state then it is possible for subsequent state transformations, or attribute acquisitions, to result in states in which two or more instances of P collapse into one. If P holds multiply often in the initial state (orin any other reachable state) then it is necessary to build the invanant using instead of =. If P is state-valued, and multiple instances never occur in any state in its property space, then it is safe to assert equality in the construction of the invariant.

Automatic inference of the first three kinds of invariants relies on the construction of the property spaces as discussed in Section 2.4. As has been discussed, the distinction between state and attribute spaces is critical forthe inference of correct invanants. However, using just the techniques described so far, TIM would lose information from which it could construct useful invariants. To give an example of how this could occur we now consider the following simple encoding of the standard Blocks world:

## Move( X,Y,Z)

| Pre:   |
|--------|
| Ad:    |
| Del:   |

$$\begin{array}{r l}{\operatorname{on}(\mathrm{X},\mathrm{Y}),}&{{}\operatorname{clear}(\mathrm{X}),}&{{}\operatorname{clear}(\mathrm{Z})}\\ {\operatorname{on}(\mathrm{X},\mathrm{Z}),}&{{}\operatorname{clear}(\mathrm{Y}),}&{{}\operatorname{clear}(\mathrm{table})}\\ {\operatorname{on}(\mathrm{X},\mathrm{Y}),}&{{}\operatorname{clear}(\mathrm{Z})}\end{array}$$

In this operator, used by Bundy et al. (1980), the add list element clear(table) makes reference to a constant. If the operator schema were to be submitted to our analysis in its current form no PRS would be built for the constant, so the rules that would be constructed, and hence the state and attribute spaces constructed, would fail to record the fact that every application of move results in a state in which the table is clear. The resulting analysis would result in incorrect invariants and types. Grant (1996) identifies this version of the move operator as flawed, because of the need to maintain state correctness by the addition of the invariant clear( table ) to the add list. However, we can analyse this schema correctly if we first abstract it to remove the constant, yielding the following new schema:

## Move( X,Y,Z,T)

| Pre:   |
|--------|
| Ad:    |
| Del:   |

$$\begin{array}{r l}{\operatorname{on}(\mathrm{X},\mathrm{Y}),}&{{}\operatorname{clear}(\mathrm{X}),}&{{}\operatorname{clear}(\mathrm{Z}),\ \operatorname{table}(\mathrm{T})}\\ {\operatorname{on}(\mathrm{X},\mathrm{Z}),}&{{}\operatorname{clear}(\mathrm{Y}),}&{{}\operatorname{clear}(\mathrm{T})}\\ {\operatorname{on}(\mathrm{X},\mathrm{Y}),}&{{}\operatorname{clear}(\mathrm{Z})}\end{array}$$

Now, given an initial state in which blockC is on blockA and blockB is on the table, we add the proposition table ( table ) (so that the new precondition can be satisfied) and the property and attribute spaces that are constructed are as follows:

$$\ o n_{1}$$

$$\begin{array}{c c c}{{c l e a r_{1}}}&{{}}&{{o n_{1}}}&{{}}&{{o n_{1}}}\end{array}$$
$bl\:lock\:A,\:bl\:lock\:B$  . 
block A, block B, blockC

$on_{2}$, $clear_{1}$$on_{2}$$clear_{1}$, $clear_{1}$$on_{2}$, $blockA$, $blockB$, $blockC$, $table$$table_{1}$$null$$clear_{1}$
The second of these is an attribute space, so our invariant extraction algorithm is not applied to it. Consequently, the only invariants we can infer are those that characterize the positions of blocks (every block is on exactly one surface).  This is a pity, as there is information available in the attribute space that could yield useful extra invariants. In particular, we would like to infer the invariant that every block can be either clear or have