The construction of transition rules follows a simple rule whereby any undeleted preconditions are used to enable a transformation from a state in which the deleted preconditions of a PRS hold to one in which the added elements of the PRS hold. Given the assumption that all deleted atoms in an operator schema must appear as preconditions in that schema, these rules correctly characterize strips-style state transformations. All possible transformations are captured because of the second phase of PRS construction. A complete set of correct transition rules is therefore constructed.

Giventhe correctness and completeness of the transition rule construction phase, correct initial allocation of objects to spaces depends simply on correctly checking membership of the initial properties of the object in the property sets, formed by uniting the rules, that are used to seed the spaces. Extension of the property spaces is done by straightforward application of the transition rules, so all configurations of properties that can be occupied by the objects in the property space will have been added by the end of the extension phase. Extension of the attribute spaces is unproblematic in the cases where no potential enabler is itself an attribute. If one is, then the process by which the attributespace of that enabler is completed could, it appears, initiate a loop in the attribute space extension process. In fact, this does not happen as TIM is able to detect when a loop has occurred and avoid repeatedly iterating over it.

The following example illustrates the problem and the way it is solved in TIM. Suppose we have three attribute spaces:
Attribute space 1

$$q_{1}\qquad p_{1}$$
$$n\,u l l$$
$$q_{1}\qquad a,\,b$$

Attribute space 2

$$r_{1}\qquad q_{1}$$
$$n\,u l\,l$$
$$r_{1}\qquad c$$
$$\mathbf{c}\mathbf{e}\ \ 3$$

## Attribute Space 3

$$p_{1}\qquad r_{1}$$
$$n\,u l l$$
$$p_{1}\qquad d$$

These spaces are extended by the addition of objects that potentiate their increasing rules, as discussed in Section 2.4. No problem arises if the enablers of these rules are states, and not attributes, but in the extension of attribute space 1 above the enabler, pl, is an attribute. The attribute space for p 1 has not yet been extended, so it is necessary to complete that space before using it to complete 1. Extension of 3 requires the extension of 2, for the same reason, and that requires the extension of 1 which requires the extension of 3, and so on.

The way TIM avoids re-entering this loop is by marking each space, as it is considered, as having been seen on this iteration. When a marked space is encountered it is not extended but is used as if it is already complete. Then a second iteration is required to extend any spaces that still require completion. Subsequent iterations will be required until the process converges. Our experiments suggest that it is unusual for there to be more than two iterations required. A worst case upper bound is o As, where o is the number of domain constants and As is the number of attribute spaces (which is limited by the number of properties), and hence quadratic in the size of the domain description.