
## Appendix C. Example Output

The following output was produced by TIM and can be found, along with other examples, on the STAN webpage. These examples show the details of the analysis performed on each of three domains: a Flat-tyre domain, a Mystery domain and a Logistics domain.  The analysis is done with respect to an initial state and a set of operator schemas. The operator schemas used in these three domains are those provided with the pddl strips releases for these domains. The initial states were taken from the pddl release. The pddl release can be found at http://www.cs.yale.edu/HTML/YALE/CS/HyPlans/mcdermott.html.

## C.1 The Tyre World

TIM: Type Inference Mechanism - support for STAN: State Analysis Planner D. Long and M. Fox, University of Durham Reading domain file: domain01.pddl Reading problem file: prob01.pddl TIM: Domain analysis complete for flat-tire-strips TIM : TYPES:

| Type T0 =   | vrench   |
|-------------|----------|
| Type T1 =   | www      |
| Type T2 =   | www      |
| Type T3 =   | trunk    |
| Type T4 =   | the-hub  |
| Type T5 =   | pump     |
| Type T6 =   | nuts     |
| Type T7 =   | jack     |

It will be noticed that the two wheels are separated into different types. This is because one wheel is intact and the other is not intact, and there is no operator for repairing wheels that are not intact. The tools have each been given different types. This is because they each appear as constants in different operators and therefore are functionally distinct.

## Tim : State Invariants:

FORALL x:T4. (on-ground(x) OR lifted(x))
FORALL x:T4, NOT (on-ground(x) AND lifted(x))
FORALL x:T3. (closed(x) OR open(x))
FORALL x:T3. NOT (closed(x) AND open(x))