# Unifying  Class-Based  Representation  Formalisms

Diego Calvanese Maurizio  Lenzerini Daniele Nardi Dipartimento di Informatica e Sistemistica Universita di Roma "La Sapienza" Via Salaria 113, I-00198 Roma, Italy CA LVA N ESEQ DIS. UN IRO MA 1. IT
LENZERINI@DIS. UNIRO MA 1. IT
NARDI@DIS. UNIRO MA 1. IT

## Abstract

The notion of class is ubiquitous in computer science and is central in many formalisms for the representation of structured knowledge used both in knowledge representation and in databases. In this paper we study the basic issues underlying such representation formalisms and single out both their common characteristics and their distinguishing features. Such investigation leads us to propose a unifying framework in which we are able to capture the fundamental aspects of several representation languages used in different contexts.

The proposed formalism is expressed in the style of description logics, which have been introduced in knowledge representation as a means to provide a semantically well-founded basis for the structural aspects of knowledge representation systems. The description logic considered in this paper is a subset of first order logic with nice computational characteristics. It is quite expressive and features a novel combination of constructs that has not been studied before. The distinguishing constructs are number restrictions, which generalize existence and functional dependencies, inverse roles, which allow one to refer to the inverse of a relationship, and possibly cyclic assertions, which are necessary for capturing real world domains. We are able to show that it is precisely such combination of constructs that makes our logic powerful enough to model the essential set of features for defining class structures that are common to frame systems, object-oriented database languages, and semantic data models. As a consequence of the established correspondences, several significant extensions of each of the above formalisms become available. The high expressiveness of the logic we propose and the need for capturing the reasoning in different contexts forces us to distinguish between unrestricted and finite model reasoning. A notable feature of our proposal is that reasoning in both cases is decidable. We argue that, by virtue of the high expressive power and of the associated reasoning capabilities on both unrestricted and finite models, our logic provides a common core for class-based representation formalisms.

## 1. Introduction

In many fields of computer science we find formalisms for the representation of objects and classes (Motschnig-Pitrik & Mylopoulous, 1992).  Generally speaking, an object denotes an element of the domain of interest, and a class denotes a set of objects with common characteristics. We use the term "class-based representation formalism" to refer to a formalism that allows one to express several kinds of relationships and constraints (e.g., subclass constraints) holding among the classes that are meaningful in a set of applications. Moreover, class-based formalisms aim at taking advantage of the class structure in order to provide various information, such as whether a class is consistent, i.e., it admits at least one object, whether a class is a subclass of another class, and more generally, whether a given constraint