whose values belong to one of several predefined domains, such as Integer, String, or Boolean.

The ER model does not provide constructs for expressing explicit disjointness or disjunction of entities, but extensions of the model allow for the use of generalization hierarchies which represent a combination of these two constructs. In order to keep the presentation simple, we do not consider generalization hierarchies in the formalization we provide, although their addition would be straightforward. Similarly, we omit attributes of relations.

We now show that all relevant aspects of the ER model can be captured in ALUNI, and thus that reasoning on an ER schema can be reduced to reasoning on the corresponding ALUNI knowledge base.  Since ALUNI is equipped with capabilities to reason on knowledge bbes, both with respect to finite and unrestricted models (see Section 6.2), the reduction shows that reasoning on the ER model, and more generally on semantic data models, is decidable.

As in the case of frame-based systems, we restrict our attention to those aspects that constitute the core of the ER model. For this reason we do not consider some features, such as keys and weak entities, that have been introduced in the literature (Chen, 1976),
but appear only in some of the formalizations of the ER model and the methodologies for conceptual modeling based on the model. A proposal for the treatment of keys in description logics is presented by Borgida and Weddell (1997).

In order to establish the correspondence between the ER model and ALUNI, we present formal syntax and semantics of ER schemata.

## 4.1 Syntax Of The Entity-Relationship Model

Although the ER model has by now become an industrial standard, several variants and extensions have been introduced, which differ in minor aspects in expressiveness and in notation (Chen, 1976; Teorey, 1989; Batini, Ceri, & Navathe, 1992; Thalheim, 1992, 1993). Also, ER schemata are usually defined using a graphical notation which is particularly useful for an easy visualization of the data dependencies, but which is not well suited for our purposes. Therefore we have chosen a formalization of the ER model which abstracts with respect to the most important characteristics and allows us to develop the correspondence to ALUNI.

In the following, for two finite sets X and Y we call a function from a subset of X
to Y an X -labeled tuple over Y . The labeled tuple T that maps x i ∈ X to y i ∈ Y i for i E {1, . . , k}, is denoted [ x 1: y 1, . . , x k : y k ]. We also write T [ x i ] to denote y i .

Definition 4.1 An ER schema is a tuple S = ( Ls, Ls, atts, rels, cards ), where
- Ls is a finite alphabet partitioned into a set Es of entity symbols, a set As of attribute symbols, a set Us of role symbols, a set Rs of relationship symbols, and a set Ds of domain symbols; each domain symbol D has an associated predefined basic domain D B D , and we assume the various basic domains to be pairwise disjoint.

- Esc Es xEs is a binary relation over Es.
- atts is a function that maps each entity symbol in Es to an As -labeled tuple over Ds.