holds between a given set of classes. From the above characterization, it should be clear that the formalisms referred to in this paper deal only with the structural aspects of objects and classes, and do not include any features for the specification of behavioral properties of objects.

Three main families of class-based formalisms are identified in this paper. The first one comes from knowledge representation and in particular from the work on semantic networks and frames (see for example Lehmann, 1992; Sowa, 1991). The second one originates in the field of databases and in particular from the work on semantic data models (see for example Hull & King, 1987). The third one arises from the work on types in programming languages and object-oriented systems (see for example Kim & Lochovsky, 1989).

In the past there have been several attempts to establish relationships among the various families of class-based formalisms (see Section 6 for a brief survey). The proposed solutions are not fully general and a formalism capturing both the modeling constructs and the reasoning techniques for all the above families is still missing. In this paper we address this problem by proposing a class-based representation formalism, based on description logics (Brachman & Levesque, 1984; Schmidt-Schauß & Smolka, 1991; Donini, Lenzerini, Nardi, & Schaerf, 1996), and by using it for comparing other formalisms.

In description logics, structured knowledge is described by means of so called concepts and roles, which denote unary and binary predicates, respectively. Starting from a set of atomic symbols one can build complex concept and role expressions by applying suitable constructors which characterize a description logic. Formally, concepts are interpreted as subsets of a domain and roles as binary relations over that domain, and all constructs are equipped with a precise set-theoretic semantics. The most common constructs include boolean operations on concepts, and quantification over roles. For example, the concept Person Π Vchild.Male , denotes the set of individuals that are instances of the concept Person and are connected through the role child only to instances of the concept Male, while the concept 3child denotes all individuals that are connected through the role child to some individual. Further constructs that have been considered important include more general forms of quantification, number restrictions, which allow one to state limits on the nmber of connections that an individual may have via a certain role, and constructs on roles, such as intersection, concatenation and inverse. A description logic knowledge base, expressing the intensional knowledge about the modeled domain, is built by stating inclusion assertions between concepts, which have to be satisfied by the models of the knowledge base.

The assertions are used to specify necessary and/or necessary and sufficient conditions for individuals to be instances of certain concepts. Reasoning on such knowledge bases includes the detection of inconsistencies in the knowledge base itself, determining whether a concept can be populated in a model of the knowledge base, and checking subsumption, i.e., whether all instances of a concept are necessarily also instances of another concept in all models of the knowledge base.

In this paper we propose a description logic called ALUNI, which is quite expressive and includes a novel combination of constructs, including number restrictions, inverse roles, and inclusion assertions with no restrictions on cycles. Such features make ALUNI powerful enough to provide a unified framework for frame systems, object-oriented languages, and semantic data models. We show this by establishing a precise correspondence with a framebbed language in the style of the one proposed by Fikes and Kehler (1985), with the