The basic reasoning services considered in object-oriented databases are subtyping
(check whether a type denotes a subset of another type in every legal instance) and type consistency (check whether a type is consistent in a legal instance). Based on Proposition 5.9, we can show that these forms of reasoning are fully captured by finite concept consistency and finite concept subsumption in ALUNI knowledge bases.

Theorem 5.10  Let S  be an object-oriented schema, T,T' two type expressions in S, and ψ(S) the translation of S. Then the following holds:
1. T is consistent in S if and only if ψ(S) F f ψ(T) ≥ L.

2. T is a subtype of T ′ in S if and only if ψ(S) |= f (T) ≥ ψ(T′).

Proof. The proof is analogous to the proof of Theorem 4.9, but it makes use of Proposition 5.9 instead of Proposition 4.8.

→
Again, the correspondence with ALUNI established by Theorem 5.10 allows us to make use of the reasoning techniques developed for ALUNI to reason on object-oriented schemas.

Observe that reasoning in object-oriented models is already PSPACE-hard (Bergamaschi
& Nebel, 1994) and thus the known algorithms are exponential. However, by resorting to ALUNI, it becomes possible to take into account for reasoning also various extensions of the object-oriented formalism. Such extensions are useful for conceptual modeling and have already been proposed in the literature (Cattell & Barry, 1997). First of all, the same considerations developed for the ER model with regard to the use of arbitrary boolean constructs on classes can be applied also in the object-oriented setting, whi provides disjunction but does not admit any form of negation. Additional features that can be added to object oriented models are inverses of attributes, cardinality constraints on set-valued attributes, and more general forms of restrictions on the values of attributes.

## 6. Related Work

In this section we briefly discuss recent results on the correspondence between class-based formalisms and on techniques for reasoning in ALUNI and in class-based representation formalisms.

## 6.1 Relationships Among Class-Based Formalisms

In the past there have been several attempts to establish relationships among class-based formalisms. Bläsius, Hedstück, and Rollinger (1990), Lenzerini, Nardi, and Simi (1991) carry out a comparative analysis of class-based languages and attempt to provide a unified view.  The analysis makes it clear that several difficulties arise in identifying a common framework for the formalisms developed in different areas.  Some recent papers address this problem. For example, an analysis of the relationships between frame-based languages and types in programming languages has been carried out by Borgida (1992), while Bergamaschi and Sartori (1992), Piza, Schewe, and Schmidt (1992) use frame-based languages to enrich the deductive capabilities of semantic and object-oriented data models.