In ALUNI no restrictions are imposed on the form that the inclusion assertions may assume. In particular we do not rule out cyclic assertions, i.e., assertions in which the concept expression on the right hand side refers, either directly or indirectly via other assertions, to the atomic concept on the left hand side. In the presence of cyclic assertions different semantics may be adopted (Nebel, 1991).  The one defined above, called descriptive semantics, accepts all interpretations that satisfy the assertions in the knowledge base, and hence interprets assertions as constraints on the domain to be modeled.  For inclusion assertions, descriptive semantics has been claimed to provide the most intuitive results
(Buchheit, Donini, Nutt, & Schaerf, 1998). Alternative semantics which have been proposed are based on fixpoint constructions (Nebel, 1991; Schild, 1994; De Giacomo & Lenzerini, 1994b), and hence allow to define in a unique way the interpretation of concepts.

In general, cycles in the knowledge base increase the complexity of reasoning (Nebel, 1991; Baader, 1996; Calvanese, 1996b) and require a special treatment by reasoning procedures (Baader, 1991; Buchheit, Donini, & Schaerf, 1993). For this reason, many DL based ssssems assume the knowledge base to be acyclic (Brachman, McGuinness, Patel-Schneider, Alperin Resnick, & Borgida, 1991; Bresciani, Franconi, & Tessaris, 1995). However, this assumption is unrealistic in practice, and cycles are definitely necessary for a correct modeling in many application domains. Indeed, the use of cycles is allowed in all data models used in databases, and, as shown in the following sections, in order to capture their semantics in ALUNI the possibility of using cyclic assertions is fundamental.

Besides inclusion assertions, some DL based systems also make use of equivalence assseeerrrooos an object to be an instance of a concept. Although this possibility is ruled out in ALUNI,
this does not limit its ability of capturing both frame based systems and database models, where the constraints that can be expressed correspond naturally to inclusion assertions.

## 2.3 Reasoning In Aluni

The basic tasks we consider when reasoning over an ALUNI knowledge base are concept consistency and concept subsumption:

- Concept consistency is the problem of deciding whether a concept C is consistent in a knowledge base K (written as K | £ C £ 1), i.e., whether K admits a model I such that C x  = 0.

- Concept subsumption is the problem of deciding whether a concept C 1 is subsumed by a concept C 2 in a knowledge base K (written as K |= C 1 Ξ C 2 ), i.e., whether C ⊆ C 7 for each model I of K.
The inclusion of number restrictions and inverse roles in ALUNI and the ability in ALUNI of using arbitrary, possibly cyclic inclusion assertions allows one to construct a knowledge base in which a certain concept is consistent but has necessarily an empty extension in all finite models of the knowledge base.  Similarly, a subsumption relation between two concepts may hold only if infinite models of the knowledge base are ruled out and only finite models are considered.