To investigate these questions we consider three definitions of priorities in the framework of Reiter's default logic.

First we analyze the computational complexity of two closely related prioritized default logics (Brewka, 1994; Baader & Hollunder, 1995). These logics are based on the semiconstructive definition of extensions of default logic (Reiter, 1980):  the priorities control the construction of extensions, ruling out those that do not respect the priorities. In the general case the complexity of the decision problems of these logics equals the complexity of those of Reiter's default logic, being complete for the second level of the polynomial hierarchy.

When the priorities are a total ordering on the defaults, the complexity decreases by one level, leading to many tractable cases when the propositional reasoning involved is tractable, for example with Horn clauses or 2-literal clauses. With arbitrary strict partial orders there is no similar decrease.

We continue by analyzing a prioritized default logic that is based on comparing the Reiter extensions of a default theory by lexicographic comparison (Rintanen, 1999). The decision problem of this logic is harder than the decision problems of Reiter's default logic, assuming that the polynomial hierarchy does not collapse.  For default theories with a total priority relation some syntactically restricted classes are easier than the corresponding uprioritized ones, but in general even total priorities do not reduce the complexity of the decision problems. For partial priorities tractability can be achieved only with extreme syntactic restrictions, the complexity being the same as with the prioritized default logics by Brewka and by Baader and Hollunder.

## 2. Preliminaries On Computational Complexity

In this section we introduce some basic concepts in computational complexity. For details see (Balcázar, Díaz, & Gabarró, 1995). The complexity class P consists of decision problems that are solvable in polynomial time by a deterministic Turing machine. NP is the class of decision problems that are solvable in polynomial time by a nondeterministic Turing machine.  The class co-NP consists of problems the complements of which are in NP. In general, the class co-C consists of problems the complements of which are in the class C. The polynomial hierarchy PH is an infinite hierarchy of complexity classes Σ f , Π f and ∆ f 0 that is defined by using oracle Turing machines as follows.

for all

$$\begin{array}{r c l c r c l}{{}}&{{}}&{{\Sigma_{0}^{p}}}&{{=}}&{{}}&{{\Pi_{0}^{p}}}&{{=}}&{{}}&{{\Delta_{0}^{p}}}&{{=}}&{{}}\\ {{\Sigma_{i\,+\,1}^{p}}}&{{=}}&{{\mathrm{NP}\,\Sigma_{i}^{p}}}&{{}}&{{\Pi_{i\,+\,1}^{p}}}&{{=}}&{{\mathrm{co\mbox{-}}\Sigma_{i\,+\,1}^{p}}}&{{\Delta_{i\,+\,1}^{p}}}&{{=}}&{{\Sigma_{i}^{p}}}\end{array}$$

1 c denotes the class of problems that is defined like the class 1 except that oracle Turing machines that use an oracle for a problem in   2 are used instead of Turing machines without such an oracle.  Oracle Turing machines with an oracle for a problem    are like ordinary Turing maines except that they may perform tests for membership in    with constant cost. A problem is Turing reducible to a problem 'if there is an oracle Turing machine with an oracle for ' that solves '. The problem is Turing reducible in polynomial time if the oracle Turing machine solves    with a polynomial number of execution steps.  A problem
-hard for a complexity class    if all problems in    are polynomial time many-one is reducible to it; that is, for all problems         there is a function in polynomial time on the size of its input and 
' We say