using bit vectors, making mutex testing for indirect interaction much more efficient (we distinguish between direct and indirect interaction in Section 2.1). Second, we observe that there is no advantage in explicit construction of the graph beyond the stage at which the fix point is reached. Our plan graph maintains a wave front which keeps track of all of the goal sets remaining to be considered during search. Since no new facts, actions or mutex relations are added beyond the fix point these goal sets can be considered without explicit copying of the fact and action layers. The wave front mechanism allows S TAN to solve very large problem instances using a fraction of the time and space consumed by Graphplan and Ipp (Koehler, Nebel, & Dimopoulos, 1997). For example, using a heuristic discussed in Section 5.1, STAN can solve the 10-disc Towers of Hanoi problem (a 1023 step plan) in less than 9 minutes.

In this paper we describe the spike and wave front mechanisms and provide experimental results indicating the performance advantages obtained.

## 2. The Spike Graph Structure

Graphplan (Blum & Furst, 1997) uses constraint satisfaction techniques to search a layered graph which represents a compressed reachability analysis of a domain. The layers correspond to snapshots of possible states at instants on a time line from the initial to the goal state. Each layer in the graph comprises a set of facts that represents the union of states reachable from the preceding layer.  This compression guarantees that the plan graph can be constructed in time polynomial in the number of action instances in the domain.

The expansion of the graph, from which solutions can be extracted, is partially encoded in binary mutex relations computed during the construction of each layer. STAN implements an efficient representation of the graph in which a wave front, discussed in Section 4, further ssssse involves the selection and exploration of a collection of action choices to see whether a plan can be constructed, using those actions at the kth time step. If no plan is found the planner backtracks over the action choices. Two important land marks anse during the construction of the plan graph. The first is the point at which the graph opens in the sense that the problem becomes, in principle, solvable. This is the layer at which all of the top level goals first become pairwise non-mutex and is referred to here as the opening layer. The second is the fix point, referred to as level off by Blum and Furst (1997), the layer after which no further changes can be made to either the action, fact or mutex information recorded in the graph at each layer.

In the original implementation of Graphplan the graph was implemented as an alternating sequence of layers of fact nodes and action nodes, with arcs connecting actions to their preconditions in the previous layer and their postconditions in the subsequent layer. The layers were constructed explicitly involving the repeated copying of large portions of the graph at each stage in maintaining the graph structure. This copying was due to two features of the graph. First, since actions with satisfied preconditions in one layer continue to have satisfied preconditions in all subsequent layers, actions that have once been added to a layer will appear in every successive action layer with the same name and the same pre- and post-conditions. Second, since facts that have once been achieved by the effects of an action will always be achieved by that action, they will continue to appear in every