simultaneously generating a candidate set whenever a goal set is memoized at the fix point.

If the candidate set and the memoized set are one and the same, then the memoization of a subset of a goal set will lead to the propagation of only a subset of the actual candidate goals into the buffer and soundness might be undermined. If we use subset memoization at the wave front then the question anses whether sets that contain a memoized subset should be propagated forward as candidates. If they are not, then completeness is potentially lost, since there might be action sequences that could have been constructed following propagation that will not now be found. If they are, then termination is potentially lost, since the set that led to the construction of the memoized subset might itself be generated as a candidate. This could happen, for example in Figure 10, if G1 is unsolvable at the fix point but is generated again by consideration of a later candidate at the buffer.

To avoid these problems we have restored full subset memoization at the wave front.

An alternative solution, which we are currently exploring, is to separate the subsets of goals memoized from the identification of the candidate sets. Both solutions avoid the loss of soundness because candidates are constructed from entire goal sets rather than from ssseesssssssssss ensures that repeated candidates can be correctly identified as they recur. In the second solution, we would separately memoize candidates as they were generated to avoid repeated generation, thereby maintaining termination. In both cases, completeness is preserved by propagating goal-sets forward as new candidates provided only that they do not contain previously encountered candidates as subsets. If a potential candidate is a superset of an entire memoized candidate then it is correct not to propagate that potential candidate into the buffer because if the memoized candidate cannot be solved at the buffer then no superset of it can be solved there either.

## 5. Experimental Results

The results presented here use STAN version 2 (available at our website). We have performed experiments companng STAN with and without the wavefront in order to demonstrate the advantages obtained by the use of the wave front. We have performed further experiments to compare STAN with the competition version of Ipp. There are some minor discrepancies in the timing mechanisms of these two systems. STAN measures elapsed time for the entire execution, whereas Ipp measures user+system time for graph construction and search but not for parsing of the problem domain and instance. On a single user machine as used for these experiments the discrepancy is negligible.

The problem domains used in this section have been selected to emphasise the benefits offered by the wave front. The important characteristic is that there should be an early fix point relative to the length of plan as instances grow. In the comparisons with Ipp the wave front accounts for the trends in performance, although STAN employs a range of other mechanisms which give it some minor advantages. Amongst these is the Tim machinery, which we have not decoupled as the problem domains used are the standard typed ones sset that no significant advantage is obtained from inferring type structures automatically. Only the resource invariants inferred by Tim are exploited by STAN version 2, and we have indicated where this gives us an advantage over Ipp. Our ablation data sets confirm