
## 4.2 Proof Search Reduction

The effects regarding the structure of the search space of a CTC (CTC neg ) prover caused by the use of lemmas are closely related to the ulility problem (e.g., Minton, 1990) from the area of explanation-based learning (EBL) and macro operatorlearning (see also Markovitch & Scott, 1993). At the first sight, lemma use could be interpreted as introducing new edges into the original search tree T because a sub-deduction (proof of a lemma) can be reduced to one inference by applying a lemma. This corresponds to macro operator learning or EBL
where inference chains are generalized and disjunctively stored as new operators or concept descriptions (e.g., Minton, 1990), respectively. We should notice, however, that the use of lemmas does not only insert new edges but also new nodes into the search tree. This comes from the fact that the structure of a tableau T 1 where a lemma is applied differs from the structure of an in other parts equal tableau T2 where the lemma proof is "expanded". This has no influence on the inferences possible with T 1 and T 2 (the edges outgoing from the nodes v 1 and v 2 that are labeled with T 1 and T 2 , respectively) but it has an effect on the value a completeness bound B assigns to the tableaux. Considering the bounds introduced in Section 2, T1 can be enumerated with a resource value which is smaller than or equal to that needed to enumerate T2. In analogy to macro operator learning and considering these remarks, we now summarize the advantages and disadvantages of using lemmas in connection with iterative deepening procedures.

A minor advantage of introducing a lemma is the advantage of decreasing path costs, i.e.

the costs of reproducing the inferences needed for its proof. The major advantage of using lemmas is that they make a restructuring of the the search space possible.

On the one hand, one can save the possibly high search effort needed for proving a useful lemma (assuming the lemma proof can be expanded within the finite segment of T to be considered). On the other hand, it is possible that a closed tableau can be reached within a smaller resource value ("resource reduction"). Then, the reordering effects usually allow us to solve problems that were previously out of reach because the search procedure gets lost in the (usually exponentially) larger segment of the search tree defined by alarger resource.

It is clear, however, that this advantage only holds if the segment of the search tree defined by the lower resource value is not increased too much by the use of the lemmas. Considenng our search bounds we can see that normally resource reductions cannot be guaranteed when using superposition generated lemmas in an ME prover. When using the inference bound a resource reduction is guaranteed if by using lemmas a proof length reduction can be obtained. In the case of the depth and weighted-depth bound in general not even a proof length reduction leads to a resource reduction.

Besides the positive effects of using lemmas, some negative effects also occur. These stem from an increased redundancy. The main disadvantage regarding the use of lemmas is the increase of the branching rate of the search tree. It is possible that a misleading solution of a subgoal may be obtained that could not be found before within a given finite segment. Even if a resource reduction from n to n ′ < n occurs it is possible that solutions of subgoals that could not be found with resource n (without lemmas) can now be found with resource n' and lemmas. This can reorder the search space in a hardly controllable manner. Considering the inference bound in some cases tableaux which could not be enumerated with resource n can now be enumerated with lemmas. It is possible that the use of lemmas