
## 5. Experimental Study

In order to conduct an experimental evaluation of our integration of top-down/bottom-up provers, we coupled two renowned provers: the ME prover SETHEO and the superposition prover Spass. We have used the version of Setheo as described by Moser et al. (1997).

Spass has been employed in version 0.55.

## 5.1  Architecture And Behavior Of The Experimental System

Our experimental environment can be described as follows: Each prover runs on its own processor and obtains the initial clause set C as input. We employed a rather efficient method to organize the preprocessing. Essentially, the top-down prover generates subgoal clauses with one of the two variants. In our environment this does not require changes in the top-down prover but can be performed with built-ins of the PROLOG-style input language of SETHEO. Since SETHEO employs CTC ncg we experimented only with subgoal clauses obtained with negative start clauses. Then, these subgoal clauses are filtered, transferred to the bottom-up prover, and integrated into its search state. The preprocessing of the bottomup proveris performed in parallel with the preprocessing of the top-down prover. The prover activates clauses with its basic heuristic until the top-down prover finishes its preprocessing. Thus, we achieve synchronization of the provers. After that, we extract the positive units from the set of active facts of Spass and filter some facts as described. Since we can employ the generated subgoal clauses of SETHEO for the filter function ϕ G t ; the generated subgoal clauses can be used as additional input of SPASS as well as for the selection of lemmas for SETHEO. Finally, the provers proceed to tackle the problem in parallel with their standard settings. By using this environment we can achieve cooperation by exchanging lemmas and subgoal clauses without one concept disturbing the other. In contrast, both concepts support each other because results obtained from one preprocessing can be employed in the ot he r.

We experimented in the light of problems stem ming from the well-known problem library TPTP v.1.2.1 (Sutcliffe et al., 1994; Sutcliffe & Suttner, 1998). In order to obtain a reliable collection of data, we employed all domains contained in the TPTP as our test set. Because these domains cover a wide range of very different problems we assume that this is a reliable test set.

Since the TPTP contains too many problems to list and discuss the runtimes of single problems, we will present an overview of the number of solved problems in the TPTP
library. Furthermore, we study in which domains cooperation is especially important and deal with the main features responsible for this. In addition we study the results in three domains in more detail to give an impression for the decrease in run time. This concerns the domains CAT (category theory), LDA (LD-algebras), and COL (combinatory logic).

The problems in the domains CAT and LDA contain equality as well as non-Horn clauses. COL is a Horn-equality domain In detail, the parameters of our experimental system are: The subgoal clause candidates were generated in such a way that for variant 1 we employed the resource k = 10 which performed best in the experiments. The use of higher resources did not yield better results.

We limited the set of subgoal clauses by N sg = 500. For variant 2 we employed k 1 = k 2 = 9