After each successful solution of a subgoal a lemma might be generated and added to the input clauses. The aim of this kind of lemma generation is to produce lemmas that are able to reduce the search amount by eliminating repeated sub-deductions. One criticism regarding this kind of lemma generation is the fact that it is unclear whether or not useful lemmas can be generated. There is no guarantee that lemmas can be produced dunng the proof run which can contribute to a proof, i.e. which can be "re-used". Furthermore, as already mentioned, the generated lemmas are usually not as general as possible due to instantiations coming from the solutions of subgoals previously solved. This can reduce the applicability of a lemma although the "generalized" proof could be re-used for refuting the input clauses.  Thus, although some hard problems could only be solved with such lemma techniques (see Astrachan & Loveland, 1997), no stable success has been reported over a large set of problems. The main disadvantages of all approaches which only aim at supporting top-down provers originate from the fact that in some domains, especially if equality is involved, superposition-based provers clearly outperform ME provers. Thus, in such domains it may be more sensible to develop techniques in order to support the more powerful bottom-up prover than the weaker top-down prover.

In order to improve bottom-up proof search by using top-down performed inferences the following approaches have been employed. Firstly, again one prover (the bottom-up prover)
is assisted by clauses derived from another prover (the top-down prover). The approach from Sutcliffe (1992) uses lemmas generated by a guided linear deduction system (and not subgoal clauses) in order to support resolution-based provers. Due to the lack of goal orientation (as described in Section 2.2) this method could not yield convincing results in practice. Secondly, there are approaches to make bottom-up provers more goal-directed by forcing them to work only with some relevant clauses which are detected by top-down calculations. The methods described by Bancilhon et al. (1986), Stickel (1994), and Hasegawa et al. (1997) transform a set of clauses into another clause set which is then evaluated in a bottom-up manner. The specific transformation provides a combination of top-down and bottom-up processing and prunes the bottom-up evaluation to relevant clauses (which bear a connection to a proof goal). Thus, obviously the bottom-up proof search becomes more goal oriented. Also the method described by Loveland et al. (1995) provides a relevancy testing for bottom-up calculations. Based on top-down proof attempts the relevancy of a clause is dynamically determined during the bottom-up calculation. In contrast to our method in these approaches the bottom-up prover has to tackle the whole proof task. Our approach for using top-down generated subgoal clauses in a bottom-up prover does not provide a relevancy testing of bottom-up inference but supports the bottom-up inference process by simplifying the original goal. Thus, the proof length may be shortened. Furthermore, parts of the search space of the bottom-up prover, which contain relevant clauses but may be difficult to enumerate, can be traversed by a single inference which provides large search reductions.

## References

Antoniou, G., & Langetepe, E. (1994). Applying SLD-resolution to aclass of non-horn logic programs. Bulletin of the IGPL, 2 (2), 231-243.