We can assess the accuracy of each variational transformation after introducing and optimizing the variational transformations for all the positive findings. Separately for each positive finding we replace the variationally transformed conditional probability P(f,+)d, ξi) with the corresponding exact conditional P(f,+)d) and compute the difference between the resulting bounds on the likelihood of the observations:

$$\mathbf{\partial}\cdot\mathbf{\partial}\left(\xi_{i}\right)$$

## Δ ̣ = P(Ƒ†|Ξ) − P(Ƒ†|Ξ \ Ξ )

$$(28)$$

where P(f+l$ \ $i) is computed without transforming the ith positive finding. The larger the difference bi is, the worse the ith variational transformation is. We should therefore introduce the transformations in the ascending order of 5 s. Put another way, we should treat exactly (not transform) those conditional probabilities whose δ i measure is large.

In practice, an intelligent method for ordering the transformations is critical. Figure 2 compares the calculation of likelihoods based on the 6; measure as opposed to a method that chooses the ordering of transformations at random. The plot corresponds to a representative diagnostic case, and shows the upper bounds on the log-likelihoods of the observed findings as a function of the number of conditional probabilities that were left intact (i.e.

not transformed). Note that the upper bound must improve (decrease) with fewer transformations. The results are striking the choice of ordering has a large effect on accuracy
(note that the plot is on a log-scale).

![0_image_0.png](0_image_0.png)

Note also that the curve for the proposed ranking is convex; thus the bound improves less the fewer transformations there are left. This is because we first remove the worst transformations, replacing them with the exact conditionals. The remaining transformations are better as indicated by the delta measure and thus the bound improves less with furt her replacements.

We make no claims for optimality of the delta method; it is simply a useful heuristic that allows us to choose an ordering for variational transformations in a computationally efficient way. Note also that our implementation of the method optimizes the variational parameters only once at the outset and chooses the ordering of further transformations based on these fixed parameters. These parameters are suboptimal for graphs in which